/*  guiftp - X window ftp client
 *
 *  Copyright (C) 1999  Luc Dufresne - ldufresne@altern.org
 *                      26, rue des Comices
 *                      59650 Villeneuve d'Ascq
 *                      FRANCE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See the file COPYING
 */
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>
#include "bookmarks.h"
#include "protos.h"
#include "connect.h"

GtkWidget *bookmarks_tree;
GtkCTreeNode *parent;
GtkWidget *txthost,*txtport,*txtdir,*txtuser,*txtpass,*txtdes;
GList *bookmarks;
struct bookmark *find_book,*find_parent_book;
GList *find_booklist;
struct bookmark*bookmark_a_transmettre;
gboolean stop;
extern GtkItemFactory *factory;

struct modify{
	GtkWidget *window;
	struct bookmark *book;
};

static struct bookmark *find_bookmark(GtkCTreeNode *node,GList *bookmarks_list);
/*static GList *find_list(GtkCTreeNode *node,GList *bookmarks_list);*/
static struct bookmark *find_parentbookmark(GtkCTreeNode *node,GList *bookmarks_list);
static void delete_item(GtkWidget *w, gpointer data);
static void delete_item2(gpointer a,gpointer b);

/*
static void print_list(gpointer a,gpointer b)
{
	struct bookmark *book=(struct bookmark *)a;
	printf("%s\n",book->desc->str);
	if(book->is_group)printf("sous goupe\n");
	else
	{
		printf("%s\n",book->host->str);
		printf("%s\n",book->port->str);
		printf("%s\n",book->dir->str);
		printf("%s\n",book->user->str);
		printf("%s\n",book->pass->str);
	}
printf("\n");
}

static void print_bookmark(struct bookmark *book)
{
	printf("%s\n",book->desc->str);
	if(book->is_group)printf("sous goupe\n");
	else
	{
		printf("%s\n",book->host->str);
		printf("%s\n",book->port->str);
		printf("%s\n",book->dir->str);
		printf("%s\n",book->user->str);
		printf("%s\n",book->pass->str);
	}
	printf("\n");
}
*/
static void sel(gpointer a,gpointer b)
{
	if(!stop){
	GtkCTreeNode *node=(GtkCTreeNode *)b;
	struct bookmark *book=(struct bookmark *)a;
	if(node==book->node){find_book=book; stop=TRUE;}
	else if(book->is_group) find_bookmark(node,book->sous_groupe);
	}	
}

static struct bookmark *find_bookmark(GtkCTreeNode *node,GList *bookmarks_list)
{
	find_book=NULL;
	g_list_foreach(bookmarks_list,sel,node);
	if(find_book!=NULL)return find_book;
	return NULL;
}

/*static void sel2(gpointer a,gpointer b)
{
	if(!stop){
	GtkCTreeNode *node=(GtkCTreeNode *)b;
	struct bookmark *book=(struct bookmark *)a;
	if(node==book->node){find_book=book; stop=TRUE;}
	else if(book->is_group) find_list(node,book->sous_groupe);
	}	
}

static GList *find_list(GtkCTreeNode *node,GList *bookmarks_list)
{
	find_book=NULL;
	find_booklist=NULL;
	g_list_foreach(bookmarks_list,sel2,node);
	if(find_booklist!=NULL) return find_booklist;
	if(find_book!=NULL) {find_booklist=bookmarks_list; return bookmarks_list;}
	return NULL;
}*/

static void sel3(gpointer a,gpointer b)
{
	if(!stop)
	{
		GtkCTreeNode *node=(GtkCTreeNode *)b;
		struct bookmark *book=(struct bookmark *)a;
		if(node==book->node)
		{
			find_book=book;
			stop=TRUE;
		}
		else
		{
			if(book->is_group) find_parentbookmark(node,book->sous_groupe);
			if(find_book)
			{
				find_parent_book=book;
				find_book=NULL;
			}
		}
	}	
}

static struct bookmark *find_parentbookmark(GtkCTreeNode *node,GList *bookmarks_list)
{
	find_parent_book=NULL;
	find_book=NULL;
	g_list_foreach(bookmarks_list,sel3,node);
	if(find_parent_book!=NULL)return find_parent_book;
	return NULL;
}

static void delete_bookmark(struct bookmark *book)
{
	struct bookmark *prent;
	GList *list=NULL;
	GtkCTreeNode *node=book->node;
	
	stop=FALSE;
	prent=find_parentbookmark(node,bookmarks);
	
	/* on libere toute la memoire */
	g_string_free(book->desc,TRUE);
	if((!book->is_group))
	{
		g_string_free(book->host,TRUE);
		g_string_free(book->port,TRUE);
		g_string_free(book->dir,TRUE);
		g_string_free(book->pass,TRUE);
		g_string_free(book->user,TRUE);
	}else list=book->sous_groupe;

	/* on enleve le bookmark de la liste chainee */
	/* et mise a jour des != listes */
	g_free(book);
	if(prent!=NULL)prent->sous_groupe=g_list_remove(prent->sous_groupe,book);
	else bookmarks=g_list_remove(bookmarks,book);

	if((list))
	{	
		g_list_foreach(list,delete_item2,NULL);
		g_list_free(list);
	}

	/* on enleve le bookmark du ctree */
	gtk_ctree_remove_node(GTK_CTREE(bookmarks_tree),node);
}

static void delete_item2(gpointer a,gpointer b)
{
	struct bookmark *book=(struct bookmark *)a;
	delete_bookmark(book);
}

static void delete_item(GtkWidget *w, gpointer data)
{
	struct bookmark *book;
	GtkCTreeNode *node=GTK_CTREE_NODE(data);
	
	stop=FALSE;
	book=find_bookmark(node,bookmarks);

	if(book==NULL){ /*printf("perdu\n");*/ return; }
	if(book->is_group && book->sous_groupe)
	{
		ask(_("Delete Group ?"),_("Are you sure to delete this group ?\n You will lost everything contained in it"));
		if(!bool)return;
	}
	delete_bookmark(book);
}

static void get_txt(GString **dest, GtkWidget *txt)
{
	gchar *temp;
	
	temp = gtk_entry_get_text( GTK_ENTRY(txt));
	*dest=g_string_new("");
	g_string_sprintf(*dest,"%s",temp);
}

static void add_group2(GtkWidget *w, gpointer data)
{
	GString *desc;
	gchar *text[1];
	struct bookmark *book;
	
	get_txt(&desc,txtdes);
	gtk_widget_destroy(w);
	text[0]=desc->str;
	book=g_malloc(sizeof(struct bookmark));
	book->is_group=TRUE;
	book->desc=g_string_new(desc->str);
	book->sous_groupe=NULL;
	book->node=gtk_ctree_insert_node(GTK_CTREE(bookmarks_tree), parent, NULL, text, 5, 
		dir, dirmask, diropen, diropenmask, FALSE, FALSE);
/*	book->groupe=bookmarks;*/
	bookmarks=g_list_append(bookmarks,book);
	g_string_free(desc,TRUE);
}

static void add_group(GtkWidget *w, gpointer data)
{
	GtkWidget *window,*button;
	GtkWidget *vbox,*hbox;
	GtkWidget *label;
	
	window = gtk_dialog_new ();
	gtk_window_set_modal (GTK_WINDOW(window),TRUE);
	gtk_widget_set_usize (window, 200, 100);
	gtk_window_set_position(GTK_WINDOW(window),GTK_WIN_POS_MOUSE);
	gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  GTK_SIGNAL_FUNC(gtk_main_quit),
			  &window);

	gtk_window_set_title (GTK_WINDOW (window), _("New group"));
	gtk_container_set_border_width (GTK_CONTAINER (window), 5);

	vbox=GTK_WIDGET(GTK_DIALOG(window)->vbox);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	label = gtk_label_new (_("Description: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txtdes = gtk_entry_new();
	gtk_widget_set_usize (txtdes, 100, 0);
	gtk_box_pack_start (GTK_BOX (hbox), txtdes, TRUE, TRUE, 0);

	gtk_widget_show_all(vbox);

	/*boutons OK/Cancel*/
	button = gtk_button_new_with_label(_("OK"));
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",add_group2, GTK_OBJECT(window));
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area), 
			  button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	gtk_widget_grab_default (button);
	button = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",gtk_widget_destroy, GTK_OBJECT(window));
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area), 
			  button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	
	gtk_widget_show(window);
	gtk_main();
}

static void add_item2(GtkWidget *w, gpointer data)
{
	GString *user,*pass,*dir,*host,*port,*desc;
	gchar *text[1];
	struct bookmark *book;
	
	get_txt(&host,txthost);
	get_txt(&port,txtport);
	get_txt(&dir,txtdir);
	get_txt(&pass,txtpass);
	get_txt(&user,txtuser);
	get_txt(&desc,txtdes);
	gtk_widget_destroy(w);
	text[0]=desc->str;
	
	book=g_malloc(sizeof(struct bookmark));
	book->is_group=FALSE;
	book->host=g_string_new(host->str);
	book->port=g_string_new(port->str);
	book->dir=g_string_new(dir->str);
	book->pass=g_string_new(pass->str);
	book->user=g_string_new(user->str);
	book->desc=g_string_new(desc->str);
	book->node=gtk_ctree_insert_node(GTK_CTREE(bookmarks_tree), parent, NULL, text, 5, 
		NULL, NULL, NULL, NULL, TRUE, FALSE);
/*	book->groupe=bookmarks;*/
	bookmarks=g_list_append(bookmarks,book);
	
	g_string_free(pass,TRUE);
	g_string_free(user,TRUE);
	g_string_free(dir,TRUE);
	g_string_free(host,TRUE);
	g_string_free(port,TRUE);
	g_string_free(desc,TRUE);
}

static void add_item(GtkWidget *w, gpointer data)
{
	GtkWidget *window,*button;
	GtkWidget *vbox,*hbox;
	GtkWidget *label;
	
	window = gtk_dialog_new ();
	gtk_window_set_modal (GTK_WINDOW(window),TRUE);
	gtk_widget_set_usize (window, 350, 175);
	gtk_window_set_position(GTK_WINDOW(window),GTK_WIN_POS_MOUSE);
	gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  GTK_SIGNAL_FUNC(gtk_main_quit),
			  &window);

	gtk_window_set_title (GTK_WINDOW (window), _("New bookmark"));
	gtk_container_set_border_width (GTK_CONTAINER (window), 5);

	vbox=GTK_WIDGET(GTK_DIALOG(window)->vbox);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	label = gtk_label_new (_("Description: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txtdes = gtk_entry_new();
	gtk_widget_set_usize (txtdes, 100, 0);
	gtk_box_pack_start (GTK_BOX (hbox), txtdes, TRUE, TRUE, 0);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	label = gtk_label_new (_("Hostname: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txthost = gtk_entry_new();
	gtk_widget_set_usize (txthost, 100, 0);
	gtk_box_pack_start (GTK_BOX (hbox), txthost, TRUE, TRUE, 0);
	label = gtk_label_new (_("Port: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txtport = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(txtport),"21");
	gtk_widget_set_usize (txtport, 15, 0);
	gtk_box_pack_start (GTK_BOX (hbox), txtport, TRUE, TRUE, 0);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	label = gtk_label_new (_("Base Directory: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txtdir = gtk_entry_new();
	gtk_widget_set_usize (txtdir, 150, 0);
	gtk_box_pack_start (GTK_BOX (hbox), txtdir, TRUE, TRUE, 0);
	
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	label = gtk_label_new (_("User Name: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txtuser = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(txtuser),"anonymous");
	gtk_widget_set_usize (txtuser, 100, 0);
	gtk_box_pack_start (GTK_BOX (hbox), txtuser, TRUE, TRUE, 0);
	label = gtk_label_new (_("Password: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txtpass = gtk_entry_new();
	gtk_widget_set_usize (txtpass, 100, 0);
	gtk_entry_set_visibility (GTK_ENTRY(txtpass), FALSE);
	gtk_box_pack_start (GTK_BOX (hbox), txtpass, TRUE, TRUE, 0);
	gtk_widget_show_all(vbox);

	/*boutons OK/Cancel*/
	button = gtk_button_new_with_label(_("OK"));
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",add_item2, GTK_OBJECT(window));
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area), 
			  button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	gtk_widget_grab_default (button);
	button = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",gtk_widget_destroy, GTK_OBJECT(window));
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area), 
			  button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	
	gtk_widget_show(window);
	gtk_main();
}

static void modify_group2(GtkWidget *w, gpointer data)
{
	GString *desc;
	g_string_free(bookmark_a_transmettre->desc,TRUE);
	get_txt(&desc,txtdes);
	bookmark_a_transmettre->desc=desc;
	gtk_ctree_node_set_text(GTK_CTREE(bookmarks_tree),bookmark_a_transmettre->node,0,desc->str);
	gtk_widget_destroy(w);
}

static void modify_group(struct bookmark *book)
{
	GtkWidget *window,*button;
	GtkWidget *vbox,*hbox;
	GtkWidget *label;
	
	window = gtk_dialog_new ();
	gtk_window_set_modal (GTK_WINDOW(window),TRUE);
	gtk_widget_set_usize (window, 200, 100);
	gtk_window_set_position(GTK_WINDOW(window),GTK_WIN_POS_MOUSE);
	gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  GTK_SIGNAL_FUNC(gtk_main_quit),
			  &window);

	gtk_window_set_title (GTK_WINDOW (window), _("Rename group"));
	gtk_container_set_border_width (GTK_CONTAINER (window), 5);

	vbox=GTK_WIDGET(GTK_DIALOG(window)->vbox);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	label = gtk_label_new (_("Description: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txtdes = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(txtdes),book->desc->str);
	gtk_widget_set_usize (txtdes, 100, 0);
	gtk_box_pack_start (GTK_BOX (hbox), txtdes, TRUE, TRUE, 0);

	gtk_widget_show_all(vbox);

	/*boutons OK/Cancel*/
	button = gtk_button_new_with_label(_("OK"));
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",modify_group2, GTK_OBJECT(window));
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area), 
			  button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	gtk_widget_grab_default (button);
	button = gtk_button_new_with_label(_("Cancel"));
	bookmark_a_transmettre=book;
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",gtk_widget_destroy, GTK_OBJECT(window));
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area), 
			  button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	
	gtk_widget_show(window);
	gtk_main();
}

static void modify_bookmark2(GtkWidget *w, gpointer data)
{
	GString *desc,*host,*port,*dir,*user,*pass;

	g_string_free(bookmark_a_transmettre->desc,TRUE);
	get_txt(&desc,txtdes);
	bookmark_a_transmettre->desc=desc;
	gtk_ctree_node_set_text(GTK_CTREE(bookmarks_tree),bookmark_a_transmettre->node,0,desc->str);
	
	g_string_free(bookmark_a_transmettre->host,TRUE);
	get_txt(&host,txthost);
	bookmark_a_transmettre->host=host;
	
	g_string_free(bookmark_a_transmettre->port,TRUE);
	get_txt(&port,txtport);
	bookmark_a_transmettre->port=port;

	g_string_free(bookmark_a_transmettre->dir,TRUE);
	get_txt(&dir,txtdir);
	bookmark_a_transmettre->dir=dir;

	g_string_free(bookmark_a_transmettre->user,TRUE);
	get_txt(&user,txtuser);
	bookmark_a_transmettre->user=user;

	g_string_free(bookmark_a_transmettre->pass,TRUE);
	get_txt(&pass,txtpass);
	bookmark_a_transmettre->pass=pass;
	
	gtk_widget_destroy(w);
}

static void modify_bookmark(struct bookmark *book)
{
	GtkWidget *window,*button;
	GtkWidget *vbox,*hbox;
	GtkWidget *label;
	
	window = gtk_dialog_new ();
	gtk_window_set_modal (GTK_WINDOW(window),TRUE);
	gtk_widget_set_usize (window, 350, 175);
	gtk_window_set_position(GTK_WINDOW(window),GTK_WIN_POS_MOUSE);
	gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  GTK_SIGNAL_FUNC(gtk_main_quit),
			  &window);

	gtk_window_set_title (GTK_WINDOW (window), _("Modify bookmark"));
	gtk_container_set_border_width (GTK_CONTAINER (window), 5);

	vbox=GTK_WIDGET(GTK_DIALOG(window)->vbox);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	label = gtk_label_new (_("Description: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txtdes = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(txtdes),book->desc->str);
	gtk_widget_set_usize (txtdes, 100, 0);
	gtk_box_pack_start (GTK_BOX (hbox), txtdes, TRUE, TRUE, 0);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	label = gtk_label_new (_("Hostname: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txthost = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(txthost),book->host->str);
	gtk_widget_set_usize (txthost, 100, 0);
	gtk_box_pack_start (GTK_BOX (hbox), txthost, TRUE, TRUE, 0);
	label = gtk_label_new (_("Port: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txtport = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(txtport),book->port->str);
	gtk_widget_set_usize (txtport, 15, 0);
	gtk_box_pack_start (GTK_BOX (hbox), txtport, TRUE, TRUE, 0);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	label = gtk_label_new (_("Base Directory: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txtdir = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(txtdir),book->dir->str);
	gtk_widget_set_usize (txtdir, 150, 0);
	gtk_box_pack_start (GTK_BOX (hbox), txtdir, TRUE, TRUE, 0);
	
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	label = gtk_label_new (_("User Name: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txtuser = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(txtuser),book->user->str);
	gtk_widget_set_usize (txtuser, 100, 0);
	gtk_box_pack_start (GTK_BOX (hbox), txtuser, TRUE, TRUE, 0);
	label = gtk_label_new (_("Password: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txtpass = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(txtpass),book->pass->str);
	gtk_widget_set_usize (txtpass, 100, 0);
	gtk_entry_set_visibility (GTK_ENTRY(txtpass), FALSE);
	gtk_box_pack_start (GTK_BOX (hbox), txtpass, TRUE, TRUE, 0);
	gtk_widget_show_all(vbox);

	/*boutons OK/Cancel*/
	button = gtk_button_new_with_label(_("OK"));
	bookmark_a_transmettre=book;
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",modify_bookmark2, GTK_OBJECT(window));
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area), 
			  button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	gtk_widget_grab_default (button);
	button = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",gtk_widget_destroy, GTK_OBJECT(window));
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area), 
			  button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	
	gtk_widget_show(window);
	gtk_main();
}

static void edit_properties(GtkWidget *w, gpointer data)
{
	struct bookmark *book;
	stop=FALSE;
	book=find_bookmark((GTK_CLIST(bookmarks_tree)->selection->data),bookmarks);
	if(book!=NULL)
	{
		
		if(book->is_group)modify_group(book);
		else modify_bookmark(book);
	}
}

static void tree_click(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
	GtkWidget *menu,*menu_item;
	
	if(event->button==3 && event->type==GDK_BUTTON_PRESS)
	{
		menu=gtk_menu_new();
		
		if(GTK_CLIST(bookmarks_tree)->selection && GTK_CLIST(bookmarks_tree)->selection->data!=parent)
		{
			menu_item=gtk_menu_item_new_with_label(_("edit..."));
			gtk_menu_append(GTK_MENU(menu),menu_item);
			gtk_signal_connect(GTK_OBJECT(menu_item),"activate",GTK_SIGNAL_FUNC(edit_properties),NULL);
			gtk_widget_show(menu_item);
	
			menu_item=gtk_menu_item_new_with_label(_("delete"));
			gtk_menu_append(GTK_MENU(menu),menu_item);
			gtk_signal_connect(GTK_OBJECT(menu_item),"activate",GTK_SIGNAL_FUNC(delete_item),GTK_CLIST(bookmarks_tree)->selection->data);
			gtk_widget_show(menu_item);
		}

		menu_item=gtk_menu_item_new_with_label(_("add item..."));
		gtk_menu_append(GTK_MENU(menu),menu_item);
		gtk_signal_connect_object(GTK_OBJECT(menu_item),"activate",GTK_SIGNAL_FUNC(add_item),NULL);
		gtk_widget_show(menu_item);
		
		menu_item=gtk_menu_item_new_with_label(_("add group..."));
		gtk_menu_append(GTK_MENU(menu),menu_item);
		gtk_signal_connect_object(GTK_OBJECT(menu_item),"activate",GTK_SIGNAL_FUNC(add_group),NULL);
		gtk_widget_show(menu_item);

		gtk_menu_popup (GTK_MENU(menu),NULL,NULL,NULL,NULL,event->button,event->time);
	}
/*	if(event->button==1 && event->type==GDK_2BUTTON_PRESS && (GTK_CLIST(bookmarks_tree)->selection)!=NULL)
	{
		edit_properties(NULL,NULL);
	}*/
}

static void tree_move(GtkCTree *ctree,GtkCTreeNode *child,GtkCTreeNode *prent,GtkCTreeNode *sibling, gpointer data)
{
	struct bookmark *childbook,*parentbook,*siblingbook,*book;
	GList *list,*oldlist;
	
	stop=FALSE;
	childbook=find_bookmark(child,bookmarks);
	stop=FALSE;
	parentbook=find_bookmark(prent,bookmarks);
	stop=FALSE;
	siblingbook=find_bookmark(sibling,bookmarks);
	
/*	printf("truc dplac\n");
	print_bookmark(childbook);
*/
	stop=FALSE;
	book=find_parentbookmark(child,bookmarks);
/*	if(book){printf("ancien parent\n"); print_bookmark(book);}*/
	if(book!=NULL)book->sous_groupe=g_list_remove(book->sous_groupe,childbook);
	else bookmarks=g_list_remove(bookmarks,childbook);

/*	if(parentbook){printf("nouveau parent\n"); print_bookmark(parentbook);}*/
	if(siblingbook)
	{
		list=g_list_alloc();
		list->data=childbook;
		if(parentbook!=NULL)oldlist=g_list_find(parentbook->sous_groupe,siblingbook);
			else oldlist=g_list_find(bookmarks,siblingbook);
		
		if(oldlist->prev)
		{	oldlist->prev->next=list;
			list->prev=oldlist->prev;
		}else
		{
			if(parentbook!=NULL) parentbook->sous_groupe=list;
			else bookmarks=list;
		}
		list->next=oldlist;
		oldlist->prev=list;
	}
	else
	{
		if(parentbook!=NULL)parentbook->sous_groupe=g_list_append(parentbook->sous_groupe,childbook);
		else bookmarks=g_list_append(bookmarks,childbook);
	}
	
	

/*	printf("\nchild\n");
	if(childbook!=NULL)print_bookmark(childbook);
	printf("\nparent\n");
	if(parentbook!=NULL)print_bookmark(parentbook);
	printf("\nsibling\n");
	if(siblingbook!=NULL)print_bookmark(siblingbook);
*/
}

static void add_tree(gpointer a,gpointer b)
{
	gchar *text;
	
	GtkCTreeNode *node=(GtkCTreeNode *)b;
	struct bookmark *book=(struct bookmark *)a;
	text=book->desc->str;
	if(book->is_group){
		book->node=gtk_ctree_insert_node(GTK_CTREE(bookmarks_tree), node, NULL, &text, 5, 
			dir, dirmask, diropen, diropenmask, FALSE, FALSE);
		g_list_foreach(book->sous_groupe,add_tree,book->node);
	}
	else book->node=gtk_ctree_insert_node(GTK_CTREE(bookmarks_tree), node, NULL, &text, 5, 
		NULL, NULL, NULL, NULL, TRUE, FALSE);
}

static void save_book(gpointer a,gpointer b)
{
	struct bookmark *book=(struct bookmark *)a;
	FILE *fichier=(FILE *)b;

	if(book->is_group)
	{
		fprintf(fichier,"group desc:\"%s\"\n",book->desc->str);
		g_list_foreach(book->sous_groupe,save_book,fichier);
		fprintf(fichier,"end\n");
	}
	else
	{
		fprintf(fichier,"bookmark desc:\"%s\" host:\"%s\" port:\"%s\" user:\"%s\" pass:\"%s\" dir:\"%s\"\n",book->desc->str,
			book->host->str,book->port->str,book->user->str,book->pass->str,book->dir->str);
	}
}

static void save_bookmarks()
{
	GString *buf;
	FILE *bookmarks_saved;

	buf=g_string_new("");
	g_string_sprintf(buf,"%s/."PACKAGE"/bookmarks",getenv("HOME"));
	if(NULL!=(bookmarks_saved=fopen(buf->str,"wt")))
	{
		chmod(buf->str,S_IRUSR | S_IWUSR);
		fprintf(bookmarks_saved,"# Automatically generated file.\n# Do not edit (or make a backup copy before doing so)\n");
		g_list_foreach(bookmarks,save_book,bookmarks_saved);
		fclose(bookmarks_saved);
	}
	g_string_free(buf,TRUE);
}

void bookmark_connect(gpointer data)
{
	struct bookmark *book=(struct bookmark *)data;
	
	if(working || connected)return;
	working=1;
	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
	host=book->host;
	port=book->port;
	connect_param(book->host,book->port,book->dir,book->user,book->pass);
}

static void add_menu(gpointer a,gpointer b)
{
	GString *path,*path2;
	struct bookmark *book=(struct bookmark *)a;
	GtkItemFactoryEntry item;
	
	path=(GString *)b;
	item.path=g_strjoin(NULL,path->str,"/",book->desc->str,NULL);
	if(book->is_group)
	{
		item.item_type="<Branch>";
		item.callback=NULL;
	}else{
		item.item_type="<Item>";
		item.callback=bookmark_connect;
	}
	gtk_item_factory_create_item (factory,&item,(gpointer)book,1);
	if(book->is_group)
	{
		path2=g_string_new(item.path);
		g_list_foreach(book->sous_groupe,add_menu,path2);
		g_string_free(path2,TRUE);
	}
	g_free(item.path);
}

static void update_menu()
{
	GString *current_path=g_string_new(_("/Bookmarks"));	
	g_list_foreach(bookmarks,add_menu,current_path);
	g_string_free(current_path,TRUE);
}

static void delete_entry(gpointer a,gpointer b)
{
	GString *path,*path2;
	struct bookmark *book=(struct bookmark *)a;
	path=(GString *)b;

	path2=g_string_new("");
	g_string_sprintf(path2,"%s/%s",path->str,book->desc->str);
	
	if(book->is_group)g_list_foreach(book->sous_groupe,delete_entry,path2);

/*	gtk_item_factory_delete_item(factory,path2->str);*/
	gtk_widget_destroy(gtk_item_factory_get_item(factory,path2->str));

	g_string_free(path2,TRUE);
}

static void clear_menu()
{
	GString *current_path=g_string_new(_("/Bookmarks"));	
	g_list_foreach(bookmarks,delete_entry,current_path);
	g_string_free(current_path,TRUE);
}

static void close_bookmarks(GtkWidget *w,GtkWidget *data)
{
	save_bookmarks();
	update_menu();
	working=0;
	gtk_widget_destroy(w);
}

static gboolean drag_compare (GtkCTree *ctree, GtkCTreeNode *source_node,
	      GtkCTreeNode *new_parent, GtkCTreeNode *new_sibling)
{
   if (new_parent)
      return TRUE;
   else
      return FALSE;
}

void edit_bookmarks(GtkWidget *w, gpointer data)
{
	GtkWidget *bookmarks_window;
	GtkWidget *scroll;
	gchar *text={N_("Bookmarks")};
	gchar *text2;

	if(working || transfert)return;
	working=1;
	bookmarks_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_modal (GTK_WINDOW(bookmarks_window),TRUE);
	gtk_signal_connect (GTK_OBJECT (bookmarks_window), "delete_event",
			  GTK_SIGNAL_FUNC(close_bookmarks),
			  NULL);
	gtk_signal_connect (GTK_OBJECT (bookmarks_window), "destroy",
			  GTK_SIGNAL_FUNC(gtk_main_quit),
			  &bookmarks_window);

	gtk_window_set_title (GTK_WINDOW (bookmarks_window), _("Bookmarks"));
	gtk_container_set_border_width (GTK_CONTAINER (bookmarks_window), 5);
	gtk_widget_set_usize (bookmarks_window, 150, 250);
	gtk_window_set_position(GTK_WINDOW(bookmarks_window),GTK_WIN_POS_MOUSE);
	
	scroll = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_AUTOMATIC);

	gtk_container_add (GTK_CONTAINER(bookmarks_window), scroll);
	gtk_widget_show (scroll);
	
	bookmarks_tree = gtk_ctree_new(1,0);
	gtk_clist_set_shadow_type(GTK_CLIST(bookmarks_tree),GTK_SHADOW_NONE);
	gtk_signal_connect(GTK_OBJECT(bookmarks_tree),"button_press_event",GTK_SIGNAL_FUNC(tree_click),bookmarks_tree);
	gtk_signal_connect_after(GTK_OBJECT(bookmarks_tree),"tree_move",GTK_SIGNAL_FUNC(tree_move),NULL);
	 gtk_ctree_set_drag_compare_func (GTK_CTREE (bookmarks_tree), drag_compare);
	gtk_clist_set_selection_mode (GTK_CLIST (bookmarks_tree), GTK_SELECTION_SINGLE);
	gtk_clist_set_reorderable (GTK_CLIST (bookmarks_tree), 1);
	gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scroll), bookmarks_tree);
	gtk_widget_show (bookmarks_tree);
	text2=g_malloc(strlen(gettext(text)));
	sprintf(text2,gettext(text));
	parent=gtk_ctree_insert_node(GTK_CTREE(bookmarks_tree), NULL, NULL, &text2, 5, 
		dir, dirmask, diropen, diropenmask, FALSE, TRUE);
	g_free(text2);
	
	g_list_foreach(bookmarks,add_tree,parent);
	
	gtk_widget_show(bookmarks_window);
	clear_menu();
	gtk_main();
}

static GString *getline(FILE *fichier)
{
	GString *temp;
	gchar buf[128];
	
	temp=g_string_new("");
	do
	{
		fgets(buf,sizeof(buf),fichier);
		g_string_append(temp,buf);
		if(feof(fichier))return temp;
	}while(strstr(buf,"\n")==NULL);
	return temp;
}

static GString *get_val(GString *buf,gchar *desc)
{
	GString *val;
	gchar *pos;
	
	pos=strstr(buf->str,desc);
	pos+=strlen(desc)+1;

	val=g_string_new("");
	while(*pos!='\"' && *pos!='\n' && *pos!='\r')
	{
		g_string_append_c(val,*pos);
		pos++;
	}
	return val;
}

static void read_bookmarks(FILE *fichier,GList **list)
{
	GString *buf;
	struct bookmark *book;
	
	while(!feof(fichier))
	{
		buf=getline(fichier);
		if(feof(fichier))return;
		if(buf->str[0]!='#')
		{
			if(0==(strncmp(buf->str,"end",3)))return;
			if(0==(strncmp(buf->str,"group",5)))
			{
				book=g_malloc(sizeof(struct bookmark));
				book->desc=get_val(buf," desc:");
				book->is_group=TRUE;
				book->sous_groupe=NULL;
				*list=g_list_append(*list,book);
				read_bookmarks(fichier,&(book->sous_groupe));
				if(feof(fichier))return;
			}
			if(0==(strncmp(buf->str,"bookmark",8)))
			{
				book=g_malloc(sizeof(struct bookmark));
				book->desc=get_val(buf," desc:");
				book->host=get_val(buf," host:");
				book->port=get_val(buf," port:");
				book->user=get_val(buf," user:");
				book->pass=get_val(buf," pass:");
				book->dir=get_val(buf," dir:");
				book->is_group=FALSE;
				*list=g_list_append(*list,book);
			}
		}
		g_string_free(buf,TRUE);
	}
}

void init_bookmarks()
{
	FILE *bookmarks_saved;
	GString *buf;
	
	buf=g_string_new("");
	g_string_sprintf(buf,"%s/."PACKAGE"/bookmarks",getenv("HOME"));
	if(NULL==(bookmarks_saved=fopen(buf->str,"rt")))
	{
		g_string_sprintf(buf,"%s/."PACKAGE"",getenv("HOME"));
		mkdir(buf->str,S_IRWXU);
		bookmarks=NULL;		
	}
	else
	{
		bookmarks=NULL;
		read_bookmarks(bookmarks_saved,&bookmarks);
		fclose(bookmarks_saved);
	}
	g_string_free(buf,TRUE);
	update_menu();
}
