/*  guiftp - X window ftp client
 *
 *  Copyright (C) 1999  Luc Dufresne - ldufresne@altern.org
 *                      26, rue des Comices
 *                      59650 Villeneuve d'Ascq
 *                      FRANCE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See the file COPYING
 */

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include "connect.h"
#include "protos.h"
#include "ftp.h"

gboolean bool;

static void get_txt(GString **dest, GtkWidget *txt)
{
	gchar *temp;
	
	temp = gtk_entry_get_text( GTK_ENTRY(txt));
	*dest=g_string_new("");
	g_string_sprintf(*dest,"%s",temp);
}

void connect_param(GString *host,GString *port,GString *dir,GString *user,GString *pass)
{
	GString *buffer;

	buffer=g_string_new("");
	g_string_sprintf(buffer,_(" Connecting to %s "),host->str);
	gtk_statusbar_push(GTK_STATUSBAR(statusbar),1,buffer->str);
	
	g_string_sprintf(buffer,_("Connecting to %s\n"),host->str);
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, buffer->str, -1);
	
	if(!connectto(host->str,port->str))
	{
		gtk_statusbar_pop(GTK_STATUSBAR(statusbar),1);
		clear_progressbar(timer);
		gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, _("Connection failed\n"), -1);
		working=0;
		g_string_free(buffer,TRUE);
		return;
	}
	connected=1;
	gtk_statusbar_pop(GTK_STATUSBAR(statusbar),1);
	gtk_statusbar_push(GTK_STATUSBAR(statusbar),1,_(" Login"));
	
	if(!login(user->str,pass->str))
	{
		clear_progressbar(timer);
		gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, _("Login failed\n"), -1);
		working=0;
		disconnect(NULL,NULL);
		g_string_free(buffer,TRUE);
		return;
	}
	gtk_statusbar_pop(GTK_STATUSBAR(statusbar),1);
	g_string_sprintf(buffer,_(" Connected to %s "),host->str);
	gtk_statusbar_push(GTK_STATUSBAR(statusbar),1,buffer->str);
	
	if(0!=strcmp(dir->str,""))
	{
		if(!chdir_r(dir->str)) pwd();
		else gtk_entry_set_text(GTK_ENTRY(txte_r),dir->str);
	}
	else pwd();
	dirr();
	
	gtk_entry_set_editable(GTK_ENTRY(txte_r),TRUE);
	g_string_free(buffer,TRUE);
	clear_progressbar(timer);
	show_remote_menu();
	working=0;
}

static void connectok(GtkWidget *w, gpointer data) {
	GString *user,*pass,*dir;
	
	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
	get_txt(&host,txthost);
	get_txt(&port,txtport);
	get_txt(&dir,txtdir);
	get_txt(&pass,txtpass);
	get_txt(&user,txtuser);
	gtk_widget_destroy(w);
	connect_param(host,port,dir,user,pass);
	g_string_free(pass,TRUE);
	g_string_free(user,TRUE);
	g_string_free(dir,TRUE);
}

static void discok(GtkWidget *w, gpointer data)
{
	bool=1;
	disconnect(w,data);
	gtk_widget_destroy(w);
}

static void ask_dis()
{
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *button;
	GtkWidget *label;
	GtkWidget *bbox;

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_modal (GTK_WINDOW(window),TRUE);
	gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  GTK_SIGNAL_FUNC(gtk_main_quit),
			  &window);
	gtk_window_set_title (GTK_WINDOW (window), _("Disconnect ?"));
	gtk_container_set_border_width (GTK_CONTAINER (window), 5);
	gtk_widget_set_usize (window, 0, 0);
	gtk_window_set_position(GTK_WINDOW(window),GTK_WIN_POS_MOUSE);
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (window), vbox);

	label = gtk_label_new (_("Do you want to close current connection ?"));
	gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
	
	/*boutons yes/no*/
	bbox = gtk_hbutton_box_new ();
	gtk_box_pack_start (GTK_BOX (vbox), bbox, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (bbox), 10);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), 
		     GTK_BUTTONBOX_SPREAD );
	button = gtk_button_new_with_label(_("Yes"));
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		discok, GTK_OBJECT(window));
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_container_add (GTK_CONTAINER (bbox), button);
	gtk_widget_grab_default (button);
	button = gtk_button_new_with_label(_("No"));
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(window));
	gtk_container_add (GTK_CONTAINER (bbox), button);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	
	gtk_widget_show_all(vbox);
	gtk_widget_show(window);
	gtk_main();
}

static void close_dialog(GtkWidget *w,GtkWidget *data)
{
	working=0;
	gtk_widget_destroy(w);
}

void dialog_connect(GtkWidget *w, gpointer data) {
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *button;
	GtkWidget *bbox;
	GtkWidget *label;
	
	if(working)
		return;
		else working=1;
	if(connected)
	{
		bool=0;
		ask_dis();
		if(bool)disconnect2(w,data);
		else
			{
			working=0;
			return;
			}
	}
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_modal (GTK_WINDOW(window),TRUE);
	gtk_signal_connect (GTK_OBJECT (window), "delete_event", close_dialog, NULL);
	gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  GTK_SIGNAL_FUNC(gtk_main_quit),
			  &window);
	gtk_window_set_title (GTK_WINDOW (window), _("Connect"));
	gtk_container_set_border_width (GTK_CONTAINER (window), 5);
	gtk_widget_set_usize (window, 350, 150);
	gtk_window_set_position(GTK_WINDOW(window),GTK_WIN_POS_MOUSE);
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (window), vbox);
	
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	label = gtk_label_new (_("Hostname: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txthost = gtk_entry_new();
	gtk_widget_set_usize (txthost, 100, 0);
	gtk_box_pack_start (GTK_BOX (hbox), txthost, TRUE, TRUE, 0);
	label = gtk_label_new (_("Port: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txtport = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(txtport),"21");
	gtk_widget_set_usize (txtport, 15, 0);
	gtk_box_pack_start (GTK_BOX (hbox), txtport, TRUE, TRUE, 0);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	label = gtk_label_new (_("Base Directory: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txtdir = gtk_entry_new();
	gtk_widget_set_usize (txtdir, 150, 0);
	gtk_box_pack_start (GTK_BOX (hbox), txtdir, TRUE, TRUE, 0);
	
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	label = gtk_label_new (_("User Name: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txtuser = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(txtuser),"anonymous");
	gtk_widget_set_usize (txtuser, 100, 0);
	gtk_box_pack_start (GTK_BOX (hbox), txtuser, TRUE, TRUE, 0);
	label = gtk_label_new (_("Password: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	txtpass = gtk_entry_new();
	gtk_widget_set_usize (txtpass, 100, 0);
	gtk_entry_set_visibility (GTK_ENTRY(txtpass), FALSE);
	gtk_box_pack_start (GTK_BOX (hbox), txtpass, TRUE, TRUE, 0);

	
	/*boutons ok/cancel*/
	bbox = gtk_hbutton_box_new ();
	gtk_box_pack_start (GTK_BOX (vbox), bbox, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (bbox), 10);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), 
		     GTK_BUTTONBOX_SPREAD );
	button = gtk_button_new_with_label(_("OK"));
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		connectok, GTK_OBJECT(window));
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_container_add (GTK_CONTAINER (bbox), button);
	gtk_widget_grab_default (button);
	button = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		close_dialog, GTK_OBJECT(window));
	gtk_container_add (GTK_CONTAINER (bbox), button);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	
	gtk_widget_show_all(vbox);
	gtk_widget_show(window);
	gtk_main();
}

void hide_remote_menu()
{
	gtk_widget_set_sensitive (disconnect_btn, 0);
	gtk_widget_set_sensitive (cd_up_remote_btn, 0);
	gtk_widget_set_sensitive (reload_remote_btn, 0);
	gtk_widget_set_sensitive (txte_r, 0);
	gtk_widget_set_sensitive (clist_r, 0);
}

void show_remote_menu()
{
	gtk_widget_set_sensitive (disconnect_btn, 1);
	gtk_widget_set_sensitive (cd_up_remote_btn, 1);
	gtk_widget_set_sensitive (reload_remote_btn, 1);
	gtk_widget_set_sensitive (txte_r, 1);
	gtk_widget_set_sensitive (clist_r, 1);
}
