/*  guiftp - X window ftp client
 *
 *  Copyright (C) 1999  Luc Dufresne - ldufresne@altern.org
 *                      26, rue des Comices
 *                      59650 Villeneuve d'Ascq
 *                      FRANCE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See the file COPYING
 */

#include <gtk/gtk.h>

#include "protos.h"

void errorbox(gchar *msg) {
	GtkWidget *dialog_window;
	GtkWidget *button;
	GtkWidget *label;
	
	dialog_window = gtk_dialog_new ();
	gtk_window_set_modal (GTK_WINDOW(dialog_window),TRUE);
	gtk_signal_connect (GTK_OBJECT (dialog_window), "destroy",
			  GTK_SIGNAL_FUNC(gtk_main_quit),
			  &dialog_window);

	gtk_window_set_title (GTK_WINDOW (dialog_window), _("Error"));
	gtk_container_set_border_width (GTK_CONTAINER (dialog_window), 0);
	gtk_widget_set_usize (dialog_window, 350, 100);
	gtk_window_set_position(GTK_WINDOW(dialog_window),GTK_WIN_POS_MOUSE);
	
	label = gtk_label_new (msg);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_window)->vbox),
                             label, TRUE, TRUE, 0);
	gtk_widget_show (label);

	button = gtk_button_new_with_label (_("close"));
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_window)->action_area), 
			  button, TRUE, TRUE, 0);
	
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (button);
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialog_window));
		
	gtk_widget_show (button);
	gtk_widget_show (dialog_window);
	gtk_main();
}

void ok(GtkWidget *w, gpointer data)
{
	bool=1;
	gtk_widget_destroy(w);
}

void notok(GtkWidget *w, gpointer data)
{
	bool=0;
	gtk_widget_destroy(w);
}

void close_ask(GtkWidget *w, gpointer data)
{
	if(!bool)working=0;
	gtk_main_quit();
}

void ask(gchar *title, gchar *question)
{
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *button;
	GtkWidget *label;
	GtkWidget *bbox;

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_modal (GTK_WINDOW(window),TRUE);
	gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  close_ask/*GTK_SIGNAL_FUNC(gtk_main_quit)*/,
			  &window);
	gtk_window_set_title (GTK_WINDOW (window), title);
	gtk_container_set_border_width (GTK_CONTAINER (window), 5);
	gtk_widget_set_usize (window, 0, 0);
	gtk_window_set_position(GTK_WINDOW(window),GTK_WIN_POS_MOUSE);
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (window), vbox);

	label = gtk_label_new (question);
	gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
	
	/*boutons yes/no*/
	bbox = gtk_hbutton_box_new ();
	gtk_box_pack_start (GTK_BOX (vbox), bbox, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (bbox), 10);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), 
		     GTK_BUTTONBOX_SPREAD );
	button = gtk_button_new_with_label(_("Yes"));
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		ok, GTK_OBJECT(window));
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_container_add (GTK_CONTAINER (bbox), button);
	gtk_widget_grab_default (button);
	button = gtk_button_new_with_label(_("No"));
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		notok, GTK_OBJECT(window));
	gtk_container_add (GTK_CONTAINER (bbox), button);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	
	gtk_widget_show_all(vbox);
	gtk_widget_show(window);
	gtk_main();	
}
