/*  guiftp - X window ftp client
 *
 *  Copyright (C) 1999  Luc Dufresne - ldufresne@altern.org
 *                      26, rue des Comices
 *                      59650 Villeneuve d'Ascq
 *                      FRANCE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See the file COPYING
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
extern int h_errno;
#include <arpa/inet.h>

#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>

#include <pthread.h>
#include <semaphore.h>

/* pour ABOR */
#include <arpa/telnet.h>

#include "ftp.h"
#include "localdir.h"
#include "connect.h"

#include <errno.h>
extern int errno;

#define sleep_time 0.01

GtkWidget *new_dir;
GList *list;
GString *buffer_text;
sem_t semaphore;
pthread_t pth;
gint download_size; /* pour le taux de transfert */
glong nb_s;

/* qq structure utilise pour passer des arguments aux threads */
struct hstruc
{
	gchar *host;
	struct hostent *h;
};

struct dstruc
{
	FILE *fichier;
	gint ds;
	gulong pos;
};

struct connectstruc
{
	struct sockaddr_in addr;
	gboolean erreur;
	GString *msg_err;
};

struct list_dir_data
{
	gchar *name;
	gboolean dir;
};

struct data_accept
{
	gint ds,data;
	gboolean ok;
};

/* les fonctions */

static void cancel(GtkWidget *w,GtkWidget *data)
{
	working=0;
	gtk_widget_destroy(w);
}

static void increase_progress_bar()
{
	gfloat new_val;
	GtkAdjustment *adj;
	
	new_val = gtk_progress_get_value( GTK_PROGRESS(progressbar) ) + 1;
	adj = GTK_PROGRESS (progressbar)->adjustment;
	if (new_val > adj->upper)
	new_val = adj->lower;
	gtk_progress_set_value (GTK_PROGRESS (progressbar), new_val);
}

void clear_progressbar(gint timer)
{
	GtkAdjustment *adj;
	adj = GTK_PROGRESS (progressbar)->adjustment;
	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),0);
	gtk_progress_set_value (GTK_PROGRESS (progressbar), adj->lower);
	gtk_timeout_remove(timer);
	timer=0;
}

gint progress_timeout(gpointer data)
{
	increase_progress_bar();
	return(TRUE);
}

static void *pth_cmd(void *cmd)
{
	gchar *cmd2;
	cmd2=cmd;

	send(sock,cmd2,strlen(cmd2),0);
	sem_post (&semaphore);
	return (NULL);
}

static void cmd(gchar *buffer)
{
	GString *buf;
	gint sem_value;

	buf=g_string_new("");
	g_string_sprintf(buf,"%s\r\n",buffer);  /*ajoute le code de fin de ligne*/
/*printf(buf->str);*/
	sem_init (&semaphore, 0, 0);
	pthread_create (&pth, NULL, pth_cmd, (void *)buf->str);
	do
	{
		sleep(sleep_time);
		while (gtk_events_pending()) gtk_main_iteration();
		sem_getvalue (&semaphore, &sem_value);
	}while(!sem_value);
	sem_destroy(&semaphore);
	g_string_free(buf,TRUE);
}

static void *pth_get_reply(void *c)
{

	gchar code1[5],code2[5],s[2];
	gint code;
	gint *code_t;
		
	code_t=c;
	
	recv(sock,code1,3,0);
	code1[3]=0;
	code2[3]=0;
	buffer_text=g_string_append(buffer_text,code1);
	code=atoi(code1);
	recv(sock,s,1,0);
	s[1]=0;
	
	if(0==strcmp(s," "))
	{
		buffer_text=g_string_append(buffer_text,s);
		do
		{
			recv(sock,s,1,0);
			buffer_text=g_string_append(buffer_text,s);

		}while(0!=strcmp(s,"\n"));
	}
	else
	{
		buffer_text=g_string_append(buffer_text,s);
		sprintf(code2,"%s ",code1);
		sprintf(code1,"%s",code2);
		do
		{
			recv(sock,s,1,0);
			buffer_text=g_string_append(buffer_text,s);
			
			code2[0]=code2[1];
			code2[1]=code2[2];
			code2[2]=code2[3];
			code2[3]=s[0];
		}while(0!=strcmp(code2,code1));
		do
		{
			recv(sock,s,1,0);
			buffer_text=g_string_append(buffer_text,s);
			}while(0!=strcmp(s,"\n"));
	}
	*code_t=code;
	sem_post (&semaphore);
	return (NULL);
}

static gint get_reply()
{
	gint code;
	gint sem_value;
	GdkColor color = { 0, 0, 0, 0xFFFF };

	buffer_text=g_string_new("");
	sem_init (&semaphore, 0, 0);
	pthread_create (&pth, NULL, pth_get_reply, (void *)&code);
	do
	{
		sleep(sleep_time);
		while (gtk_events_pending()) gtk_main_iteration();
		sem_getvalue (&semaphore, &sem_value);
	}while(!sem_value);

	gtk_text_insert( GTK_TEXT(text), NULL, &color, NULL, buffer_text->str, -1);
/*printf(buffer_text->str);*/
	sem_destroy(&semaphore);
	g_string_free(buffer_text,TRUE);
	return code;
}

/*initialisation de la connection pour les donnes*/
static gint dataconnect()
{
	gint data,l;
	struct sockaddr_in temp;
	struct sockaddr_in addr2;	
	gchar buf[100];
	gchar *a,*p;
		
	if((data=socket(AF_INET, SOCK_STREAM, 0))==-1) 
        {
                /*perror("socket");*/
		errorbox(strerror(errno));
                return(-1);
	}
	getsockname(sock,(struct sockaddr*)&addr2,&l);
	                  /*on recoie les donnes de la meme adresse mais pas le meme port*/
	addr2.sin_port=0; /*le systme trouve lui meme un port*/
	
	if(bind(data,(struct sockaddr *)&addr2,sizeof(addr2))==-1)
	{
		/*perror("bind");*/
		errorbox(strerror(errno));
		return(-1);
	}
		
	if(listen(data,1)==-1)
	{
		/*perror("listen");*/
		errorbox(strerror(errno));
		return(-1);
	}

	l=sizeof(temp);
	if(getsockname(data,(struct sockaddr *)&temp,&l)==-1)
	{
                /*perror("getsockname");*/
		errorbox(strerror(errno));
                return(-1);
	}
	#define	UC(b)	(((gint)b)&0xff)
	a = (gchar *)&temp.sin_addr;
	p = (gchar *)&temp.sin_port;
	sprintf(buf,"PORT %d,%d,%d,%d,%d,%d",UC(a[0]),UC(a[1]),UC(a[2]),UC(a[3]),UC(p[0]),UC(p[1]));
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, buf, -1);
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "\n", -1);

	cmd(buf);
	get_reply();
	return data;
}

void disconnect2(GtkWidget *w, gpointer data) {

	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "QUIT\n", -1);
	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
        cmd("QUIT");
        get_reply();
	close(sock);
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, _("Connection closed\n"), -1);
	gtk_widget_set_sensitive (disconnect_btn, 0);
	hide_remote_menu();
	connected=0;
	gtk_statusbar_pop(GTK_STATUSBAR(statusbar),1);
	gtk_entry_set_editable(GTK_ENTRY(txte_r),FALSE);
	gtk_entry_set_text(GTK_ENTRY(txte_r),"");
	gtk_clist_clear(GTK_CLIST(clist_r));
	clear_progressbar(timer);
}

void disconnect(GtkWidget *w, gpointer data) {

	if(!connected)return;
	if(working)
		return;
		else working=1;
	
	disconnect2(w,data);
	working=0;
}

static void *pth_gethostbyname(void *ht)
{
	struct hstruc *ht2;
	
	ht2=ht;
	ht2->h=gethostbyname(ht2->host);
	sem_post (&semaphore);
	return (NULL);
}

static void *pth_connect(void *conn)
{
	struct connectstruc *conn2;
	struct sockaddr_in addr;
	
	conn2=conn;
	addr=conn2->addr;
	if(connect(sock, (struct sockaddr *)&addr, sizeof(struct sockaddr))==-1)
	{
		/*perror("connect");
		errorbox(_("Connection refused"));*/
		conn2->erreur=1;
		conn2->msg_err=g_string_new("");
		g_string_sprintf(conn2->msg_err,strerror(errno));
	}
	sem_post (&semaphore);
	return (NULL);
}

gint connectto(gchar *host,gchar *port)
{
	struct hstruc ht;
	struct connectstruc conn;
	struct hostent *h;
	struct sockaddr_in addr;
	gint sem_value;
	
	ht.host=host;

	/*recherche de l hote*/
	sem_init (&semaphore, 0, 0);
	pthread_create (&pth, NULL, pth_gethostbyname, (void *)&ht);
	do
	{
		sleep(sleep_time);
		while (gtk_events_pending())gtk_main_iteration();
		sem_getvalue (&semaphore, &sem_value);
	}while(!sem_value);

	sem_destroy(&semaphore);
	h=ht.h;
	if(h==NULL)
	{
		/*herror("gethostbyname");*/
		/*errorbox(_("Host not found"));*/
		errorbox((gchar *)hstrerror(h_errno));
		return 0;
	}
	if((sock=socket(AF_INET, SOCK_STREAM, 0))==-1)	/*get the socket descriptor*/
	{
		/*perror("socket");
		errorbox(_("Host not found"));*/
		errorbox(strerror(errno));
		return 0;
	}
	addr.sin_family=AF_INET;
	addr.sin_port=htons(atoi(port));
	
	/*printf("Host name  : %s\n", h->h_name);
	printf("IP Address : %s\n",inet_ntoa(*((struct in_addr*)h->h_addr)));*/

	addr.sin_addr.s_addr=inet_addr(inet_ntoa(*((struct in_addr *)h->h_addr)));

	bzero(&(addr.sin_zero),8);
	
	/*connexion*/
	sem_init (&semaphore, 0, 0);
	conn.erreur=0;
	conn.addr=addr;
	pthread_create (&pth, NULL, pth_connect, (void *)&conn);
	do
	{
		sleep(sleep_time);
		while (gtk_events_pending()) gtk_main_iteration();
		sem_getvalue (&semaphore, &sem_value);
	}while(!sem_value);
	sem_destroy(&semaphore);
	if(conn.erreur){
		errorbox(conn.msg_err->str);
		g_string_free(conn.msg_err,TRUE);
		return 0;
	}
	get_reply();	
	return 1;
}

gint login(gchar *user,gchar *pass)
{
	GString *buffer;
	gint code;
	
	buffer=g_string_new("");
	g_string_sprintf(buffer,"USER %s",user);
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, buffer->str, -1);
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "\n", -1);
	cmd(buffer->str);
	if((code=get_reply())==530)
	{
		errorbox(_("Login refused"));
		return 0;

	}
	if(code==331)
	{
		gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "PASS xxxxxxxx\n", -1);
		g_string_sprintf(buffer,"PASS %s",pass);
		cmd(buffer->str);
		if(530==get_reply())
		{
			errorbox(_("Login refused"));
			return 0;
		}
	}
	g_string_free(buffer,TRUE);
	return 1;
}

/*la rponse doit avoir le format suivant : 257 "current dir" blablabla*/
static void *pth_get_reply_pwd(void *c)
{
	gchar code[6],s[2];
	gint *code_t;
	gint code2;
	code_t=c;
	
	recv(sock,code,5,0);
	code[5]=0;
	if(0!=strcmp(code,"257 \""))
	{
		code2=0;
		*code_t=code2;
		sem_post (&semaphore);
		return (NULL);
	}
	buffer_text=g_string_append(buffer_text,code);
	s[1]=0;
	do
	{
		recv(sock,s,1,0);
		buffer_text=g_string_append(buffer_text,s);
	}while(0!=strcmp(s,"\n"));
	code2=1;
	*code_t=code2;
	sem_post (&semaphore);
	return NULL;
}

static gint get_reply_pwd()
{
	gint code;
	gint sem_value;
	GdkColor color = { 0, 0, 0, 0xFFFF };
	gchar i=0,*str,s[2];
	
	buffer_text=g_string_new("");
	sem_init (&semaphore, 0, 0);
	pthread_create (&pth, NULL, pth_get_reply_pwd, (void *)&code);
	do
	{
		sleep(sleep_time);
		while (gtk_events_pending()) gtk_main_iteration();
		sem_getvalue (&semaphore, &sem_value);
	}while(!sem_value);

/*printf(buffer_text->str);*/
	gtk_text_insert( GTK_TEXT(text), NULL, &color, NULL, buffer_text->str, -1);
	str=buffer_text->str;
	while(  *(str+i*sizeof(gchar))    !=34){i++;} /* 34=" */
	s[1]=0;
	i++;
	gtk_entry_set_text(GTK_ENTRY(txte_r),"");
	while( *(str+i*sizeof(gchar)) !=34){
		s[0]= *(str+i*sizeof(gchar)) ;
		i++;
		gtk_entry_append_text(GTK_ENTRY(txte_r),s);
	}
	sem_destroy(&semaphore);
	g_string_free(buffer_text,TRUE);
	return code;
}

gint pwd()
{
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "PWD\n", -1);
        cmd("PWD");
        get_reply_pwd();
	return 1;
}

static void *pth_accept_data(void *c)
{
	struct data_accept *dta;
	struct sockaddr_in from;
	gint l;
	
	dta=c;
	dta->ds=accept(dta->data,(struct sockaddr *)&from,&l);
	
	sem_post (&semaphore);
	return (NULL);
}

static void *pth_get_list(void *c)
{
	gchar s[1001];
	gint i,*ds;
	
	ds=c;
	while((i=recv(*ds,s,1000,0))>0)
	{			
		s[i]=0;
		buffer_text=g_string_append(buffer_text,s);
	}
	sem_post (&semaphore);
	return (NULL);
}

/* ne marche qu'avec un serveur UNIX pour l instant */
gint dirr()
{
	gint ds,data,i,j,r,sem_value;
	
	GString *tmp;
	gboolean dir;
	gboolean link;
	gchar name[255];
	gchar size[255];
	GdkColor color = { 0, 0, 0, 0xFFFF };
	GdkColor color2 = { 0, 0, 0xD000, 0xD000 };
	gchar text2[2][1024];
	gchar *texts[2];
	struct data_accept dta;
	
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "TYPE A\n", -1);
        cmd("TYPE A");
        get_reply();

	if((data=dataconnect())==-1)return 0;
	
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "LIST\n", -1);
        cmd("LIST");
	
	dta.data=data;
	sem_init (&semaphore, 0, 0);
	pthread_create (&pth, NULL, pth_accept_data, &dta);
	do
	{
		sleep(sleep_time);
		while (gtk_events_pending()) gtk_main_iteration();
		sem_getvalue (&semaphore, &sem_value);
	}while(!sem_value);
	
	if(dta.ds==-1)
	{
		errorbox(strerror(errno));
		return 0;
	}
	ds=dta.ds;
	
	get_reply();
	
	buffer_text=g_string_new("");
	tmp=buffer_text;

	sem_init (&semaphore, 0, 0);
	pthread_create (&pth, NULL, pth_get_list, &ds);
	do
	{
		sleep(sleep_time);
		while (gtk_events_pending()) gtk_main_iteration();
		sem_getvalue (&semaphore, &sem_value);
	}while(!sem_value);
	sem_destroy(&semaphore);

/*	pour le debuggage */	
/*	printf(tmp->str);*/

	
	j=0;
	/* est ce que ca commence avec total xxxx ? */
	if(tmp->str[0]==116 && tmp->str[1]==111 && tmp->str[2]==116 && tmp->str[3]==97 && tmp->str[4]==108)
	{
		while(tmp->str[j]!=0x0A)j++;
		j++;
	}
	/* "-rw-rw-r-- n user group size date date date file" */
	gtk_clist_freeze(GTK_CLIST(clist_r));
	gtk_clist_clear(GTK_CLIST(clist_r));

	while(j<tmp->len)
	{
		dir=0;
		link=0;
		if(tmp->str[j]==100)dir=1;
		if(tmp->str[j]==108)link=1;
		while(tmp->str[j]!=32)j++;    /* 32 = espace */
		while(tmp->str[j]==32)j++;
		while(tmp->str[j]!=32)j++;
		while(tmp->str[j]==32)j++;
		while(tmp->str[j]!=32)j++;
		while(tmp->str[j]==32)j++;
		while(tmp->str[j]!=32)j++;
		while(tmp->str[j]==32)j++;
		i=0;
		while((size[i] = tmp->str[j])!=32){ i++; j++;}
		size[i]=0;
		while(tmp->str[j]==32)j++;
		while(tmp->str[j]!=32)j++;
		while(tmp->str[j]==32)j++;
		while(tmp->str[j]!=32)j++;
		while(tmp->str[j]==32)j++;
		while(tmp->str[j]!=32)j++;
		while(tmp->str[j]==32)j++;
		i=0;
		while((name[i] = tmp->str[j])!=0x0D) {i++; j++;}
		name[i]=0;
		j+=2;

		
		if(0!=strcmp(".",name) && 0!=strcmp("..",name))
		{
			sprintf (text2[0], "%s", name);
			sprintf (text2[1], "%s", size);
			texts[0] = text2[0];
			texts[1] = text2[1];
			r = gtk_clist_append(GTK_CLIST(clist_r),texts);
			if(dir)
			{
				gtk_clist_set_foreground(GTK_CLIST(clist_r),r,&color);
				gtk_clist_set_row_data(GTK_CLIST(clist_r),r,"d");
			}
			else
			if(link)
			{	
				gtk_clist_set_foreground(GTK_CLIST(clist_r),r,&color2);
				if(name[strlen(name)-1]==47)
					gtk_clist_set_row_data(GTK_CLIST(clist_r),r,"ld");
				else
					gtk_clist_set_row_data(GTK_CLIST(clist_r),r,"lf");
			}
			else
				gtk_clist_set_row_data(GTK_CLIST(clist_r),r,"f");
		}
		
		/*printf("%s ",name);
		printf("%s",size);
		if(dir)printf(" dir");
		printf("\n");*/
	}
	
	gtk_clist_thaw(GTK_CLIST(clist_r));

	g_string_free(tmp,TRUE);
	
	close(ds);
	close(data);
	get_reply();
	
	return 1;
}

static void *pth_download(void *sdownload)
{
	FILE *fichier;
	gint i,ds;
	gchar s[MAXBUFFER_SIZE];
	struct dstruc *sdown;
	
	sdown=sdownload;
	fichier=sdown->fichier;
	ds=sdown->ds;
	
	while((i=recv(ds,s,MAXBUFFER_SIZE,0))>0)
	{			
		fwrite(s,sizeof(gchar),i,fichier);
		sdown->pos+=i;
	}
	sem_post (&semaphore);
	return (NULL);
}

gint download_timeout(gpointer data)
{
	GString *buffer;
	gfloat t;
	gchar *file=(gchar *)data;
	
	buffer=g_string_new("");
	nb_s++;
	t=(gfloat)download_size/(gfloat)nb_s;
	if(t>1024)
	{
		t/=1024;
		if(t>1024)
		{
			t/=1024;
			g_string_sprintf(buffer,_(" getting %s (%.2f mb/s) "),file,t);
		}
		else g_string_sprintf(buffer,_(" getting %s (%.2f kb/s) "),file,t);
	}else g_string_sprintf(buffer,_(" getting %s (%.2f b/s) "),file,t);

	gtk_statusbar_pop(GTK_STATUSBAR(statusbar),1);
	gtk_statusbar_push(GTK_STATUSBAR(statusbar),1,buffer->str);
	g_string_free(buffer,TRUE);
	return(TRUE);
}

void download(gchar *file,gulong size)
{
	GString *buffer;
	gint ds,data,l;
	FILE *tmp;
	struct sockaddr_in from;
	gint n;
	struct stat mf;
	struct dirent **eps;
	struct dstruc sdownload;
	gint sem_value,download_timer;
	gboolean cont=FALSE;
	gulong size_cont=0;
	
	/* on vrifie que le fichier n'existe pas */
	n = scandir ("./", &eps, NULL, alphasort);
	buffer=g_string_new("");
	if (n >= 0)
	{
		gint cnt;
		for (cnt = 0; cnt < n; ++cnt)
		{
			stat (eps[cnt]->d_name,&mf);
			if(0 == strcmp(eps[cnt]->d_name,file) && !S_ISDIR(mf.st_mode))
			{
				if(mf.st_size<size)
				{
					size_cont=mf.st_size;
					g_string_sprintf(buffer,_("Do you want to continue the transfer of \"%s\"\nat the position %d ?"),file,size_cont);
					ask(_("Continue the file tranfer ?"),buffer->str);
					if(bool)cont=TRUE;
				}
				if(!cont)
				{
					g_string_sprintf(buffer,_("The file \"%s\" already exists\nOverwrite it ?"),file);
					ask(_("Overwrite file ?"),buffer->str);
					if(!bool)
					{
						g_string_free(buffer,TRUE);
						return;
					}
				}
			}
		}
	}
	
	if(cont)tmp=fopen(file,"a+b");
		else tmp=fopen(file,"w+b");
	if(tmp==NULL)
	{
		g_string_sprintf(buffer,_("Could not create the file \"%s\""),file);
		errorbox(buffer->str);
		return;
	}

	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
	
	g_string_sprintf(buffer,_(" getting %s "),file);
	gtk_statusbar_push(GTK_STATUSBAR(statusbar),1,buffer->str);
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "TYPE I\n", -1);
	cmd("TYPE I");
	get_reply();
	
	if((data=dataconnect())==-1)
	{
		clear_progressbar(timer);
		return;
	}

	if(cont)
	{
		g_string_sprintf(buffer,"REST %lu",(gulong) size_cont);
		gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, buffer->str, -1);
		gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "\n", -1);
		cmd(buffer->str);
		if(350!=get_reply())
		{
			fclose(tmp);
			g_string_sprintf(buffer,_("It is impossible to continue the transfer, do you want to overwrite \"%s\" ?"),file);
			ask(_("Overwrite file ?"),buffer->str);
			if(!bool)
			{
				g_string_free(buffer,TRUE);
				return;
			}
			cont=FALSE;
			tmp=fopen(file,"w+b");
		}
	}
	
	g_string_sprintf(buffer,"RETR %s",file);
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, buffer->str, -1);
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "\n", -1);

	cmd(buffer->str);
	if((ds=accept(data,(struct sockaddr *)&from,&l))==-1)
	{
		/*perror("accept");*/
		errorbox(strerror(errno));
		gtk_statusbar_pop(GTK_STATUSBAR(statusbar),1);
		clear_progressbar(timer);
		return;
	}
	get_reply();
	clear_progressbar(timer);
	
	sdownload.fichier=tmp;
	sdownload.ds=ds;
	if(cont) sdownload.pos=(gint) size_cont;
		else sdownload.pos=0;
	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),0);
	gtk_progress_configure(GTK_PROGRESS(progressbar),0,0,size);
	gtk_progress_set_format_string(GTK_PROGRESS(progressbar),_("%v bytes - %p%%"));
	gtk_progress_set_show_text(GTK_PROGRESS(progressbar),TRUE);
	sem_init (&semaphore, 0, 0);
	pthread_create (&pth, NULL, pth_download, (void *)&sdownload);
	gtk_widget_set_sensitive (abort_btn, 1);
	nb_s=0;
	download_timer=gtk_timeout_add(1000,download_timeout,file);
	do
	{
		
		sleep(sleep_time);  /* voir s'il n y a pas mieux              */
		             /* pour eviter de trop charger la machine */
		
		if(cont) download_size=sdownload.pos-size_cont;
			else download_size=sdownload.pos;
		gtk_progress_set_value(GTK_PROGRESS(progressbar),sdownload.pos);
		while (gtk_events_pending()) gtk_main_iteration();
		sem_getvalue (&semaphore, &sem_value);
	}while(!sem_value);
	gtk_timeout_remove(download_timer);
	gtk_widget_set_sensitive (abort_btn, 0);
	sem_destroy(&semaphore);
	gtk_progress_set_show_text(GTK_PROGRESS(progressbar),FALSE);
	gtk_progress_set_value(GTK_PROGRESS(progressbar),0);
	fclose(tmp);
	
	close(data);
	close(ds);
	get_reply();
	g_string_free(buffer,TRUE);
	gtk_statusbar_pop(GTK_STATUSBAR(statusbar),1);
	dirl();
}

static void *pth_upload(void *sdownload)
{
	FILE *f;
	gint i,ds;
	gchar s[MAXBUFFER_SIZE];
	struct dstruc *sdown;
	
	sdown=sdownload;
	f=sdown->fichier;
	ds=sdown->ds;
	while(!feof(f))
	{
		i=sizeof(gchar) * fread(s,sizeof(gchar),sizeof(s),f);
		sdown->pos+=i;
		send(ds,s,i,0);
	}
	sem_post (&semaphore);
	return (NULL);
}

gint upload_timeout(gpointer data)
{
	GString *buffer;
	gfloat t;
	gchar *file=(gchar *)data;
	
	buffer=g_string_new("");
	nb_s++;
	t=(gfloat)download_size/(gfloat)nb_s;
	if(t>1024)
	{
		t/=1024;
		if(t>1024)
		{
			t/=1024;
			g_string_sprintf(buffer,_(" putting %s (%.2f mb/s) "),file,t);
		}
		else g_string_sprintf(buffer,_(" putting %s (%.2f kb/s) "),file,t);
	}else g_string_sprintf(buffer,_(" putting %s (%.2f b/s) "),file,t);

	gtk_statusbar_pop(GTK_STATUSBAR(statusbar),1);
	gtk_statusbar_push(GTK_STATUSBAR(statusbar),1,buffer->str);
	g_string_free(buffer,TRUE);
	return(TRUE);
}

void upload(gchar *file,gulong size_local)
{
	GString *buffer;
	gint data,row;
	gchar *c;
	gint ds,l;
	FILE *f;
	struct sockaddr_in from;
	struct dstruc sdownload;
	gint sem_value,download_timer;
	gulong size;
	struct stat stat_fichier;
	gulong size_remote=0;  /* pour stocker la taille du fichier sur le serveur
	                         si une partie a dja t transfre */
	gchar *text2;
	gboolean cont=FALSE;
		
	buffer=g_string_new("");
	
	if(NULL==(f=fopen(file,"rb")))
	{
		g_string_sprintf(buffer,_("Couldn't open the file \"%s\""),file);
		errorbox(buffer->str);
		g_string_free(buffer,TRUE);
		return;
	}

	row=0;
	while(gtk_clist_get_text(GTK_CLIST(clist_r),row,0,&c)!=0)
	{
		if(strcmp(c,file)==0)
		{
			gtk_clist_get_text(GTK_CLIST(clist_r),row,1,&text2);
			size_remote=atol(text2);

			if(size_remote<size_local)
			{
				g_string_sprintf(buffer,_("Do you want to continue the transfer of \"%s\"\nat the position %d ?"),file,size_remote);
				ask(_("Continue the file tranfer ?"),buffer->str);
				if(bool)cont=TRUE;
			}			
			if(!cont)
			{
				g_string_sprintf(buffer,_("The file \"%s\" already exists\nOverwrite it ?"),file);
				ask(_("Overwite file ?"),buffer->str);
				if(!bool)
				{
					g_string_free(buffer,TRUE);
					return;
				}
			}
		}
		row++;
	}
	
	if(cont)fseek(f,size_remote,SEEK_SET);
	
	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
	g_string_sprintf(buffer,_(" putting %s "),file);
	gtk_statusbar_push(GTK_STATUSBAR(statusbar),1,buffer->str);
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "TYPE I\n", -1);
	cmd("TYPE I");
	get_reply();
	
	if((data=dataconnect())==-1)
	{
		g_string_free(buffer,TRUE);
		clear_progressbar(timer);
		return;
	}
	if(cont) g_string_sprintf(buffer,"APPE %s",file);
	else g_string_sprintf(buffer,"STOR %s",file);
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, buffer->str, -1);
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "\n", -1);
	cmd(buffer->str);
	get_reply();

	if((ds=accept(data,(struct sockaddr *)&from,&l))==-1)
	{
		/*perror("accept");*/
		errorbox(strerror(errno));
		gtk_statusbar_pop(GTK_STATUSBAR(statusbar),1);
		g_string_free(buffer,TRUE);
		clear_progressbar(timer);
		return;
	}
	clear_progressbar(timer);

	
	stat(file,&stat_fichier);
	size=stat_fichier.st_size;

	sdownload.fichier=f;
	sdownload.ds=ds;
	if(cont) sdownload.pos=size_remote;
		else sdownload.pos=0;
	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),0);
	gtk_progress_configure(GTK_PROGRESS(progressbar),0,0,size);
	gtk_progress_set_format_string(GTK_PROGRESS(progressbar),_("%v bytes - %p%%"));
	gtk_progress_set_show_text(GTK_PROGRESS(progressbar),TRUE);
	sem_init (&semaphore, 0, 0);
	pthread_create (&pth, NULL, pth_upload, (void *)&sdownload);
	gtk_widget_set_sensitive (abort_btn, 1);
	nb_s=0;
	download_timer=gtk_timeout_add(1000,upload_timeout,file);
	do
	{

		sleep(sleep_time);  /* voir s'il n y a pas mieux              */
		             /* pour eviter de trop charger la machine */

		
		if(cont) download_size=sdownload.pos-size_remote;
			else download_size=sdownload.pos;
		gtk_progress_set_value(GTK_PROGRESS(progressbar),sdownload.pos);
		while (gtk_events_pending()) gtk_main_iteration();
		sem_getvalue (&semaphore, &sem_value);
	}while(!sem_value);
	gtk_timeout_remove(download_timer);
	gtk_widget_set_sensitive (abort_btn, 0);
	sem_destroy(&semaphore);
	gtk_progress_set_show_text(GTK_PROGRESS(progressbar),FALSE);
	gtk_progress_set_value(GTK_PROGRESS(progressbar),0);

	close(data);
	close(ds);
	get_reply();
	fclose(f);
	g_string_free(buffer,TRUE);
	gtk_statusbar_pop(GTK_STATUSBAR(statusbar),1);
}


void reloadr(GtkWidget *w, gpointer data)
{
	if(!connected)return;
	if(working) return;
		else working=1;	

	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
	dirr();
	clear_progressbar(timer);
	working=0;
}

static void cdup_r2()
{
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "CDUP\n", -1);
	cmd("CDUP");
	get_reply();
	pwd();
	dirr();
}

static void cdup_r()
{
	if(!connected)return;
	if(working)return;
		else working=1;
	
	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
	cdup_r2();
	clear_progressbar(timer);
	working=0;
}

void cdupr(GtkWidget *w, gpointer data)
{
	cdup_r();
}

gint chdir_r(gchar *dir)
{
	GString *buf;
	
	buf=g_string_new("");
	g_string_sprintf(buf,"CWD %s",dir);
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, buf->str, -1);
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "\n", -1);
	cmd(buf->str);
	if(250!=get_reply())
	{
		errorbox(_("Directory not found"));
		working=0;
		return 0;
	}
	g_string_free(buf,TRUE);
	return 1;
}

gint chdirr(GtkWidget *w, GtkWidget *data)
{
	
	if(!connected)return 0;
	if(working)return 0;
		else working=1;

	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
	if(!chdir_r(gtk_entry_get_text( GTK_ENTRY(data))))
	{
		clear_progressbar(timer);
		return 0;
	}
	dirr();
	clear_progressbar(timer);
	working=0;
	return 1;
}

void chdirr2(GtkWidget *w,GtkWidget *data)
{
	if(!chdir_r(gtk_entry_get_text(GTK_ENTRY(new_dir))))
	{
		return;
	}
	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
	pwd();
	dirr();
	gtk_widget_destroy(data);
	clear_progressbar(timer);
	working=0;
}


void chdirr_gui(GtkWidget *w,GtkWidget *data)
{
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *button;
	GtkWidget *bbox;
	GtkWidget *label;

	if(!connected)return;
	if(working)return;
		else working=1;
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  cancel,&window);
	gtk_window_set_title (GTK_WINDOW (window), _("Change remote directory"));
	gtk_container_set_border_width (GTK_CONTAINER (window), 5);
	gtk_widget_set_usize (window, 250, 75);
	gtk_window_set_position(GTK_WINDOW(window),GTK_WIN_POS_MOUSE);
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (window), vbox);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	label = gtk_label_new (_("New directory: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	new_dir = gtk_entry_new();
	gtk_widget_set_usize (new_dir, 100, 0);
	gtk_box_pack_start (GTK_BOX (hbox), new_dir, TRUE, TRUE, 0);
	
	/*boutons ok/cancel*/
	bbox = gtk_hbutton_box_new ();
	gtk_box_pack_start (GTK_BOX (vbox), bbox, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (bbox), 10);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), 
		     GTK_BUTTONBOX_SPREAD );
	button = gtk_button_new_with_label(_("OK"));
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
		chdirr2, GTK_OBJECT(window));
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_container_add (GTK_CONTAINER (bbox), button);
	gtk_widget_grab_default (button);
	button = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		cancel, GTK_OBJECT(window));
	gtk_container_add (GTK_CONTAINER (bbox), button);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	
	gtk_widget_show_all(vbox);
	gtk_widget_show(window);
}

static void link2fileptr(gchar **file,gchar **link, gchar **ptr)
{
	gchar *truc;
	gint i;
	
	truc = strstr(*link," -> ");
	*file = g_malloc(strlen(*link));
	i=0;
	while(*link+i*sizeof(gchar)!=truc)
	{
		(*file)[i]=(*link)[i];
		i++;
	}
	(*file)[i]=0;
	truc+=4;
	*ptr=g_strdup(truc);
}

static void download_link(gchar *lien,gchar *nom)
{
	GString *buffer;
	if(-1==symlink(nom,lien))
	{
		buffer=g_string_new("");
		g_string_sprintf(buffer,_("Couldn't create the link \"%s\""),lien);
		errorbox(buffer->str);
		g_string_free(buffer,TRUE);
	}
}

static void download_dir(gchar *dir)
{
	gint row=0;
	gchar *text;
	GString *buffer;
	gchar *buffer2,*buffer3;
	gint n;
	struct stat mf;
	struct dirent **eps;
	gulong size;
	
	/* on vrifie que le rpertoire n'existe pas */
	bool = 0;
	n = scandir ("./", &eps, NULL, alphasort);
	buffer=g_string_new("");
	if (n >= 0)
	{
		gint cnt;
		for (cnt = 0; cnt < n; ++cnt)
		{
			stat (eps[cnt]->d_name,&mf);
			if(0 == strcmp(eps[cnt]->d_name,dir) && S_ISDIR(mf.st_mode))
			{
				g_string_sprintf(buffer,_("The directory \"%s\" already exists\nContinue ?"),dir);
				ask(_("Continue ?"),buffer->str);
				if(!bool)
					return;
			}
		}
	}
	
	if(!bool)
	{
		if(-1==mkdir(dir,S_IRWXU))
		{
			g_string_sprintf(buffer,_("Could not create the directory \"%s\""),dir);
			errorbox(buffer->str);
			return;
		}
	}
	g_string_free(buffer,TRUE);
	chdir(dir);
	dirl();
	gtk_entry_set_text(GTK_ENTRY(txte_l),(gchar *)get_dir_name());

	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
	if(!chdir_r(dir))
	{
		clear_progressbar(timer);
		return;
	}
	dirr();
	pwd();
	clear_progressbar(timer);

	for(;;)
	{
		if(0==gtk_clist_get_text(GTK_CLIST(clist_r),row,1,&text))
			break;
		size=atol(text);
		if(0==gtk_clist_get_text(GTK_CLIST(clist_r),row,0,&text))
			break;
		/*if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"d")!=0)
			download(text);
		else download_dir(text);*/
		if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"f")==0)
			download(text,size);
		if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"ld")==0)
		{
			link2fileptr(&buffer2,&text,&buffer3);
			download_link(buffer2,buffer3);
			g_free(buffer2);
			g_free(buffer3);
		}
		if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"lf")==0)
		{
			link2fileptr(&buffer2,&text,&buffer3);
			download_link(buffer2,buffer3);
			g_free(buffer2);
			g_free(buffer3);
		}
		if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"d")==0)
			download_dir(text);
		row++;
	}

	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
	cdup_r2();
	dirr();
	pwd();
	clear_progressbar(timer);

	chdir("..");
	dirl();
	gtk_entry_set_text(GTK_ENTRY(txte_l),(gchar *)get_dir_name());
}

static void sel(gpointer a,gpointer b)
{
	list = g_list_append(list,a);
}

static void sel_down(gpointer a,gpointer b)
{
	gchar *text;
	gint row;
	gulong size;
	gchar *buffer,*buffer2;
	
	row = GPOINTER_TO_INT (a);
	gtk_clist_get_text(GTK_CLIST(clist_r),row,1,&text);
	size=atol(text);
	gtk_clist_get_text(GTK_CLIST(clist_r),row,0,&text);
	if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"f")==0)
		download(text,size);
	if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"ld")==0)
	{
		link2fileptr(&buffer,&text,&buffer2);
		download_link(buffer,buffer2);
		g_free(buffer);
		g_free(buffer2);
	}
	if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"lf")==0)
	{
		link2fileptr(&buffer,&text,&buffer2);
		download_link(buffer,buffer2);
		g_free(buffer);
		g_free(buffer2);
	}
	if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"d")==0)
		download_dir(text);
}

void go_download(GtkWidget *w, gpointer data)
{
	if(!connected)return;
	if(working)return;
		else working=1;
	ask(_("Download files ?"),_("Download the selected files ?"));
	if(!bool)
	{
		working=0;
		return;
	}
	list = NULL;
	transfert=1;
	g_list_foreach(GTK_CLIST(clist_r)->selection,sel,NULL);
	g_list_foreach(list,sel_down,NULL);
	g_list_free(list);
	working=0;
	transfert=0;
}

static void upload_dir(gchar *dir)
{
	GString *buffer;
	GString *cdir;
	gint row;
	gchar *text2,*text3,*c;
	gulong size;

	cdir=g_string_new("");
	buffer=g_string_new("");
	g_string_sprintf(cdir,"%s",dir);
	
	row=0;
	bool=0;
	while(gtk_clist_get_text(GTK_CLIST(clist_r),row,0,&c)!=0)
	{
		if(strcmp(c,cdir->str)==0)
		{
			g_string_sprintf(buffer,_("The directory \"%s\" already exists\nContinue ?"),cdir->str);
			ask(_("Continue ?"),buffer->str);
			if(!bool)
			{
				g_string_free(buffer,TRUE);
				return;
			}
		}
		row++;
	}

	if(-1==chdir(dir))
	{
		g_string_sprintf(buffer,_("Couldn't open the directory \"%s\""),dir);
		errorbox(buffer->str);
		return;
	}
	dirl();

	if(!bool)
	{
		g_string_sprintf(buffer,"MKD %s",cdir->str);
		gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, buffer->str, -1);
		gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "\n", -1);
		cmd(buffer->str);
		if(257!=get_reply())
		{
			g_string_sprintf(buffer,_("Could not create the directory \"%s\""),cdir->str);
			errorbox(buffer->str);
			g_string_free(buffer,TRUE);
			return;
		}
	}

	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
	if(0==chdir_r(cdir->str))
	{
		clear_progressbar(timer);
		g_string_free(buffer,TRUE);
		return;
	}
	dirr();
	pwd();
	clear_progressbar(timer);
		
	row=0;
	gtk_entry_set_text(GTK_ENTRY(txte_l),(gchar *)get_dir_name());
	for(;;)
	{
		if(0==gtk_clist_get_text(GTK_CLIST(clist_l),row,0,&text2))
			break;
		if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_l),row),"d")!=0)
		{
			gtk_clist_get_text(GTK_CLIST(clist_l),row,1,&text3);
			size=atol(text3);
			upload(text2,size);
		}
		else upload_dir(text2);
		row++;
	}
	chdir("..");
	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
	cdup_r2();
	dirl();
	gtk_entry_set_text(GTK_ENTRY(txte_l),(gchar *)get_dir_name());
	clear_progressbar(timer);
}

static void sel_up(gpointer a,gpointer b)
{
	gchar *text,*text2;
	gint row;
	gulong size;
	
	row = GPOINTER_TO_INT (a);
	gtk_clist_get_text(GTK_CLIST(clist_l),row,0,&text);
	if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_l),row),"d")!=0)
	{
		gtk_clist_get_text(GTK_CLIST(clist_l),row,1,&text2);
		size=atol(text2);
		upload(text,size);
	}
	else upload_dir(text);
}

void go_upload(GtkWidget *w, gpointer data)
{
	if(!connected)return;
	if(working) return;
		else working=1;	
	ask(_("Upload files ?"),_("Upload the selected files ?"));
	if(!bool)
	{
		working=0;
		return;
	}
	list = NULL;
	transfert=1;
	g_list_foreach(GTK_CLIST(clist_l)->selection,sel,NULL);
	g_list_foreach(list,sel_up,NULL);
	g_list_free(list);
	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
	dirr();
	clear_progressbar(timer);
	transfert=0;
	working=0;
}

static void makedir(GtkWidget *w,GtkWidget *data)
{
	GString *buffer;

	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
	buffer=g_string_new("");
	g_string_sprintf(buffer,"MKD %s",gtk_entry_get_text(GTK_ENTRY(new_dir)));
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, buffer->str, -1);
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "\n", -1);
	cmd(buffer->str);
	if(257!=get_reply())
	{
		clear_progressbar(timer);
		g_string_sprintf(buffer,_("Could not create the directory \"%s\""),gtk_entry_get_text( GTK_ENTRY(new_dir)));
		errorbox(buffer->str);
		g_string_free(buffer,TRUE);
		return;
	}
	gtk_widget_destroy(data);
	dirr();
	pwd();
	g_string_free(buffer,TRUE);
	clear_progressbar(timer);
	working=0;
}

void make_dirr(GtkWidget *w, gpointer data)
{
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *button;
	GtkWidget *bbox;
	GtkWidget *label;

	if(!connected)return;
	if(working) return;
		else working=1;
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  cancel,
			  &window);
	gtk_window_set_title (GTK_WINDOW (window), _("Make new directory"));
	gtk_container_set_border_width (GTK_CONTAINER (window), 5);
	gtk_widget_set_usize (window, 250, 75);
	gtk_window_set_position(GTK_WINDOW(window),GTK_WIN_POS_MOUSE);
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (window), vbox);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	label = gtk_label_new (_("New directory: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	new_dir = gtk_entry_new();
	gtk_widget_set_usize (new_dir, 100, 0);
	gtk_box_pack_start (GTK_BOX (hbox), new_dir, TRUE, TRUE, 0);
	
	/*boutons ok/cancel*/
	bbox = gtk_hbutton_box_new ();
	gtk_box_pack_start (GTK_BOX (vbox), bbox, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (bbox), 10);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), 
		     GTK_BUTTONBOX_SPREAD );
	button = gtk_button_new_with_label(_("OK"));
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
		makedir, GTK_OBJECT(window));
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_container_add (GTK_CONTAINER (bbox), button);
	gtk_widget_grab_default (button);
	button = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		cancel, GTK_OBJECT(window));
	gtk_container_add (GTK_CONTAINER (bbox), button);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	
	gtk_widget_show_all(vbox);
	gtk_widget_show(window);
}

static void delete_file(gchar *name)
{
	GString *buffer;

	buffer=g_string_new("");
	g_string_sprintf(buffer,"DELE %s",name);
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, buffer->str, -1);
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "\n", -1);
	cmd(buffer->str);
	if(250!=get_reply())
	{
		g_string_sprintf(buffer,_("Couldn't delete \"%s\""),name),
		errorbox(buffer->str);			
	}
	g_string_free(buffer,TRUE);
}

static void sel_del(gpointer a,gpointer b)
{
	gchar *text2,*buffer2;
	gint row;
	
	row = GPOINTER_TO_INT (a);
	gtk_clist_get_text(GTK_CLIST(clist_r),row,0,&text2);
	if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"f")==0)
		delete_file(text2);
	
	if(strcmp((gchar*)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"ld")==0
		|| strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"lf")==0)
	{
		link2file(&buffer2,&text2);
		delete_file(buffer2);
		g_free(buffer2);
	}
}

void delr(GtkWidget *w, gpointer data)
{
	if(!connected)return;
	if(working) return;
		else working=1;
	ask(_("Delete files ?"),_("Delete the selected files ?"));
	if(!bool)
	{
		working=0;
		return;
	}

	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
	g_list_foreach(GTK_CLIST(clist_r)->selection,sel_del,NULL);
	dirr();
	pwd();
	clear_progressbar(timer);
	working=0;
}

static void delete_dir(gchar *name)
{
	GString *buffer;
	
	buffer=g_string_new("");
	g_string_sprintf(buffer,"RMD %s",name);
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, buffer->str, -1);
	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "\n", -1);
	cmd(buffer->str);
	if(250!=get_reply())
	{
		g_string_sprintf(buffer,_("Couldn't delete \"%s\"\nMake sure the directory is empty"),name),
		errorbox(buffer->str);			
	}
	g_string_free(buffer,TRUE);		
}

static void sel_del_dir(gpointer a,gpointer b)
{
	gchar *text2;
	gint row;
	row = GPOINTER_TO_INT (a);
	gtk_clist_get_text(GTK_CLIST(clist_r),row,0,&text2);
	if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"d")==0)
		delete_dir(text2);
}

void del_dirr(GtkWidget *w, gpointer data)
{
	if(!connected)return;
	if(working) return;
		else working=1;
	ask(_("Delete directories ?"),_("Delete the selected directories ?"));
	if(!bool)
	{
		working=0;
		return;
	}
	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
	g_list_foreach(GTK_CLIST(clist_r)->selection,sel_del_dir,NULL);
	dirr();
	pwd();
	clear_progressbar(timer);
	working=0;
}

static void make_list(gpointer a,gpointer b)
{
	gchar *text;
	
	GList **list=(GList **)b;
	struct list_dir_data *data;
	gint row;	
	row = GPOINTER_TO_INT (a);
	data=(struct list_dir_data *)g_malloc(sizeof(struct list_dir_data));
	
	gtk_clist_get_text(GTK_CLIST(clist_r),row,0,&text);

	if(strcmp((gchar*)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"ld")==0
		|| strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"lf")==0)
	link2file(&data->name,&text);
	else data->name=g_strdup(text);

	if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"d")==0)data->dir=TRUE;
		else data->dir=FALSE;
	
	*list=g_list_append(*list,data);
}

static void free_dir_list(gpointer a,gpointer b)
{
	struct list_dir_data *data=(struct list_dir_data *)a;
	g_free(data->name);
	g_free(data);
}

static void sel_delr_rec(gpointer a,gpointer b)
{
	GList *list=NULL;
	struct list_dir_data *data=(struct list_dir_data *)a;

	if(data->dir)
	{
		chdir_r(data->name);
		dirr();
		pwd();
		if(GTK_CLIST(clist_r)->rows!=0)gtk_clist_select_all(GTK_CLIST(clist_r));
		g_list_foreach(GTK_CLIST(clist_r)->selection,make_list,&list);
		g_list_foreach(list,sel_delr_rec,NULL);
		cdup_r2();
		delete_dir(data->name);
		g_list_foreach(list,free_dir_list,NULL);
		g_list_free(list);
	}
	else delete_file(data->name);
}

void delr_rec(GtkWidget *w, gpointer data)
{
	GList *list=NULL;
	
	if(!connected)return;
	if(working) return;
		else working=1;
	ask(_("Delete files ?"),_("Delete recursively the selected files ?\nAll the selected file, directories and subdirectories will be erased"));
	if(!bool)
	{
		working=0;
		return;
	}
	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
	g_list_foreach(GTK_CLIST(clist_r)->selection,make_list,&list);
	g_list_foreach(list,sel_delr_rec,NULL);
	g_list_foreach(list,free_dir_list,NULL);
	g_list_free(list);
	dirr();
	pwd();
	clear_progressbar(timer);
	working=0;
}

void link2file(gchar **file,gchar **link)
{
        gchar *truc;
        gint i;

        truc = strstr(*link," -> ");
        *file = g_malloc(strlen(*link));
        i=0;
        while(*link+i*sizeof(gchar)!=truc)
        {
                (*file)[i]=(*link)[i];
                i++;
        }
        (*file)[i]=0;
}

/* a ameliorer y a qq petits pb */
void stop_job(GtkWidget *w, gpointer data)
{
	char msg = IAC;
	FILE *out;
	  
	if(!connected || !working || !transfert) return;
	  
	pthread_cancel(pth);
	sem_post (&semaphore);
	
	/* code priqu a IglooFTP, voir ce que ca fait exactement */
	out = fdopen (dup (sock), "a");
	setlinebuf (out);
	fprintf (out, "%c%c", IAC, IP);
	fflush (out);
	if (send (sock, &msg, 1, MSG_OOB) == -1) printf("marche pas\n");
	fprintf (out, "%c", DM);
	fflush (out);
	fclose (out);
	/* fin */

	gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, "ABOR\n", -1);
	cmd("ABOR");
	get_reply();

	transfert=0;
	working=0;
}
