/*  guiftp - X window ftp client
 *
 *  Copyright (C) 1999  Luc Dufresne - ldufresne@altern.org
 *                      26, rue des Comices
 *                      59650 Villeneuve d'Ascq
 *                      FRANCE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See the file COPYING
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>
#include <stdlib.h>

#include "localdir.h"
#include "protos.h"

GtkWidget *new_dir;

/*from glibc2 (a little bit modified*/
gchar *get_dir_name()
{
  gchar *pwd;
  struct stat dotstat, pwdstat;

  pwd = getenv ("PWD");
  if (pwd != NULL &&
      stat (".", &dotstat) == 0 &&
      stat (pwd, &pwdstat) == 0 &&
      pwdstat.st_dev == dotstat.st_dev &&
      pwdstat.st_ino == dotstat.st_ino)
    /* The PWD value is correct.  Use it.  */
    return pwd; /*g_strdup (pwd);*/

  return getcwd ((gchar *) NULL, 0);
}
/*end*/

void dirl()
{
	struct dirent **eps;
	gint n;
	gchar text[2][1024];
	gchar *texts[2];
	gint r;
	GdkColor color = { 0, 0, 0, 0xFFFF };
	struct stat mf;

	gtk_clist_freeze(GTK_CLIST(clist_l));
	gtk_clist_clear(GTK_CLIST(clist_l));
	n = scandir ("./", &eps, NULL, alphasort);
	if (n >= 0)
	{
		gint cnt;
		for (cnt = 0; cnt < n; ++cnt)
		{
			stat (eps[cnt]->d_name,&mf);
			if(0!=strcmp(".",eps[cnt]->d_name) && 0!=strcmp("..",eps[cnt]->d_name))
			{
				sprintf (text[0], "%s", eps[cnt]->d_name);
				sprintf (text[1], "%d", (gint) mf.st_size);
				texts[0] = text[0];
				texts[1] = text[1];
				r = gtk_clist_append(GTK_CLIST(clist_l),texts);
			
				if(S_ISDIR(mf.st_mode))
				{
					gtk_clist_set_foreground(GTK_CLIST(clist_l),r,&color);
					gtk_clist_set_row_data(GTK_CLIST(clist_l),r,"d");
				}
				else
				gtk_clist_set_row_data(GTK_CLIST(clist_l),r,"f");
			}
		}
		/*puts (eps[cnt]->d_name);*/
	}
	else
	errorbox(_("Couldn't open the directory"));
	gtk_clist_thaw(GTK_CLIST(clist_l));
}

void chdirl(GtkWidget *w,GtkWidget *data)
{
	GString *buffer;
	if(transfert)return;
	if(-1==chdir(gtk_entry_get_text( GTK_ENTRY(data))))
	{
		buffer = g_string_new("");
		g_string_sprintf(buffer,_("Couldn't open the directory \"%s\""),gtk_entry_get_text(GTK_ENTRY(data)));
		errorbox(buffer->str);
		g_string_free(buffer,TRUE);
		return;
	}
	dirl();
}

void chdirl2(GtkWidget *w,GtkWidget *data)
{
	GString *buffer;
	if(transfert)return;
	if(-1==chdir(gtk_entry_get_text( GTK_ENTRY(new_dir))))
	{
		buffer = g_string_new("");
		g_string_sprintf(buffer,_("Couldn't open the directory \"%s\""),gtk_entry_get_text( GTK_ENTRY(new_dir)));
		errorbox(buffer->str);
		g_string_free(buffer,TRUE);
		return;
	}
	dirl();
	gtk_entry_set_text(GTK_ENTRY(txte_l),get_dir_name());
	gtk_widget_destroy(data);
}

void cdupl(GtkWidget *w, gpointer data)
{
	if(transfert)return;
	chdir("..");
	gtk_entry_set_text(GTK_ENTRY(txte_l),get_dir_name());
	dirl();
}

void reloadl(GtkWidget *w, gpointer data)
{
	dirl();
}

void chdirl_gui(GtkWidget *w,GtkWidget *data)
{
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *button;
	GtkWidget *bbox;
	GtkWidget *label;

	if(transfert)return;
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  GTK_SIGNAL_FUNC(gtk_widget_destroy),
			  &window);
	gtk_window_set_title (GTK_WINDOW (window), _("Change local directory"));
	gtk_container_set_border_width (GTK_CONTAINER (window), 5);
	gtk_widget_set_usize (window, 250, 75);
	gtk_window_set_position(GTK_WINDOW(window),GTK_WIN_POS_MOUSE);
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (window), vbox);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	label = gtk_label_new (_("New directory: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	new_dir = gtk_entry_new();
	gtk_widget_set_usize (new_dir, 100, 0);
	gtk_box_pack_start (GTK_BOX (hbox), new_dir, TRUE, TRUE, 0);
	
	/*boutons ok/cancel*/
	bbox = gtk_hbutton_box_new ();
	gtk_box_pack_start (GTK_BOX (vbox), bbox, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (bbox), 10);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), 
		     GTK_BUTTONBOX_SPREAD );
	button = gtk_button_new_with_label(_("OK"));
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
		chdirl2, GTK_OBJECT(window));
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_container_add (GTK_CONTAINER (bbox), button);
	gtk_widget_grab_default (button);
	button = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(window));
	gtk_container_add (GTK_CONTAINER (bbox), button);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	
	gtk_widget_show_all(vbox);
	gtk_widget_show(window);
}

static void makedir(GtkWidget *w,GtkWidget *data)
{
	GString *buffer;
	if(transfert)return;
	if(-1==mkdir(gtk_entry_get_text( GTK_ENTRY(new_dir)),S_IRWXU))
	{
		buffer=g_string_new("");
		g_string_sprintf(buffer,_("Could not create the directory \"%s\""),gtk_entry_get_text( GTK_ENTRY(new_dir)));
		errorbox(buffer->str);
		g_string_free(buffer,TRUE);
		return;
	}
	dirl();
	gtk_widget_destroy(data);
}

void make_dirl(GtkWidget *w, gpointer data)
{
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *button;
	GtkWidget *bbox;
	GtkWidget *label;

	if(transfert)return;
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  GTK_SIGNAL_FUNC(gtk_widget_destroy),
			  &window);
	gtk_window_set_title (GTK_WINDOW (window), _("Make new directory"));
	gtk_container_set_border_width (GTK_CONTAINER (window), 5);
	gtk_widget_set_usize (window, 250, 75);
	gtk_window_set_position(GTK_WINDOW(window),GTK_WIN_POS_MOUSE);
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (window), vbox);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	label = gtk_label_new (_("New directory: "));
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
	new_dir = gtk_entry_new();
	gtk_widget_set_usize (new_dir, 100, 0);
	gtk_box_pack_start (GTK_BOX (hbox), new_dir, TRUE, TRUE, 0);
	
	/*boutons ok/cancel*/
	bbox = gtk_hbutton_box_new ();
	gtk_box_pack_start (GTK_BOX (vbox), bbox, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (bbox), 10);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), 
		     GTK_BUTTONBOX_SPREAD );
	button = gtk_button_new_with_label(_("OK"));
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
		makedir, GTK_OBJECT(window));
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_container_add (GTK_CONTAINER (bbox), button);
	gtk_widget_grab_default (button);
	button = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(window));
	gtk_container_add (GTK_CONTAINER (bbox), button);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	
	gtk_widget_show_all(vbox);
	gtk_widget_show(window);
}

static void sel_del(gpointer a,gpointer b)
{
	gchar *text;
	GString *buffer;
	gint row;
	if(transfert)return;
	row = GPOINTER_TO_INT (a);
	gtk_clist_get_text(GTK_CLIST(clist_l),row,0,&text);
	if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_l),row),"d")!=0)
		if(0!=remove(text))
		{
			buffer=g_string_new("");
			g_string_sprintf(buffer,_("Couldn't delete \"%s\""),text),
			errorbox(buffer->str);
			g_string_free(buffer,TRUE);
		}
}

void dell(GtkWidget *w, gpointer data)
{
	if(transfert)return;
	ask(_("Delete files ?"),_("Delete the selected files ?"));
	if(!bool)return;
	g_list_foreach(GTK_CLIST(clist_l)->selection,sel_del,NULL);
	dirl();
}


static void sel_del_dir(gpointer a,gpointer b)
{
	gchar *text;
	GString *buffer;
	gint row;
	if(transfert)return;
	row = GPOINTER_TO_INT (a);
	gtk_clist_get_text(GTK_CLIST(clist_l),row,0,&text);
	if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_l),row),"d")==0)
		if(0!=remove(text))
		{
			buffer=g_string_new("");
			g_string_sprintf(buffer,_("Couldn't delete \"%s\"\nMake sure the directory is empty"),text),
			errorbox(buffer->str);
			g_string_free(buffer,TRUE);
		}
}

void del_dirl(GtkWidget *w, gpointer data)
{
	if(transfert)return;
	ask(_("Delete directories ?"),_("Delete the selected directories ?"));
	if(!bool)return;
	g_list_foreach(GTK_CLIST(clist_l)->selection,sel_del_dir,NULL);
	dirl();
}

static void del_file_rec(gchar *text)
{
	GString *buffer;
	if(0!=remove(text))
	{
		buffer=g_string_new("");
		g_string_sprintf(buffer,_("Couldn't delete \"%s\""),text),
		errorbox(buffer->str);
		g_string_free(buffer,TRUE);
	}
}

static void del_dir_rec(gchar *text)
{
	GString *buffer;
	struct dirent **eps;
	struct stat mf;
	gint n,cnt;
	
	if(0==chdir(text))
	{
		n=scandir ("./", &eps, NULL, alphasort);
		for (cnt = 0; cnt < n; ++cnt)
		{
			stat (eps[cnt]->d_name,&mf);
			if(0!=strcmp(".",eps[cnt]->d_name) && 0!=strcmp("..",eps[cnt]->d_name))
			{
				if(S_ISDIR(mf.st_mode)) del_dir_rec(eps[cnt]->d_name);
					else del_file_rec(eps[cnt]->d_name);
			}
		}
		chdir("..");
	}
	if(0!=remove(text))
	{
		buffer=g_string_new("");
		g_string_sprintf(buffer,_("Couldn't delete \"%s\""),text),
		errorbox(buffer->str);
		g_string_free(buffer,TRUE);
	}
}

static void sel_dell_rec(gpointer a,gpointer b)
{
	gchar *text;

	gint row;
	if(transfert)return;
	row = GPOINTER_TO_INT (a);
	gtk_clist_get_text(GTK_CLIST(clist_l),row,0,&text);
	if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_l),row),"d")==0) del_dir_rec(text);
		else del_file_rec(text);
}

void dell_rec(GtkWidget *w, gpointer data)
{
	if(transfert)return;
	ask(_("Delete files ?"),_("Delete recursively the selected files ?\nAll the selected file, directories and subdirectories will be erased"));
	if(!bool) return;
	g_list_foreach(GTK_CLIST(clist_l)->selection,sel_dell_rec,NULL);
	dirl();
}
