/*  guiftp - X window ftp client
 *
 *  Copyright (C) 1999  Luc Dufresne - ldufresne@altern.org
 *                      26, rue des Comices
 *                      59650 Villeneuve d'Ascq
 *                      FRANCE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See the file COPYING
 */

#include <stdlib.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>

#include "connect.h"
#include "protos.h"
#include "ftp.h"
#include "localdir.h"
#include "bookmarks.h"

#include "xpm/dir.xpm"
#include "xpm/diropen.xpm"

GtkItemFactory *factory;

static void about(GtkWidget *w, gpointer data) {
	GtkWidget *dialog_window;
	GtkWidget *button;
	GtkWidget *label;
	
	dialog_window = gtk_dialog_new ();
	gtk_signal_connect (GTK_OBJECT (dialog_window), "destroy",
			  GTK_SIGNAL_FUNC(gtk_widget_destroyed),
			  &dialog_window);

	gtk_window_set_title (GTK_WINDOW (dialog_window), _("About"));
	gtk_container_set_border_width (GTK_CONTAINER (dialog_window), 0);
	gtk_widget_set_usize (dialog_window, 470, 400);
	gtk_window_set_position(GTK_WINDOW(dialog_window),GTK_WIN_POS_MOUSE);
	
	label = gtk_label_new (""PACKAGE" "VERSION"\n\n(c) 1999 Luc Dufresne\nldufresne@altern.org\n
			Very special thanks to Deff (aka Vincent Deffontaines)\n
			
			This program is free software; you can redistribute it and/or modify
			it under the terms of the GNU General Public License as published by
			the Free Software Foundation; either version 2 of the License, or
			(at your option) any later version.
			
			This program is distributed in the hope that it will be useful,
			but WITHOUT ANY WARRANTY; without even the implied warranty of
			MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
			GNU General Public License for more details.
			
			You should have received a copy of the GNU General Public License
			along with this program; if not, write to the Free Software
			Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA");
			
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_window)->vbox),
                             label, TRUE, TRUE, 0);
	gtk_widget_show (label);

	button = gtk_button_new_with_label (_("close"));
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_window)->action_area), 
			  button, TRUE, TRUE, 0);
	
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (button);
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialog_window));
		
	gtk_widget_show (button);
	gtk_widget_show (dialog_window);
}

static void clear_messages(GtkWidget *w, gpointer data) {

	guint pos;
   	pos=gtk_text_get_length(GTK_TEXT(text));
	gtk_text_freeze(GTK_TEXT(text));
	gtk_text_backward_delete(GTK_TEXT(text),pos);
	gtk_text_thaw(GTK_TEXT(text));
}

/* sortie du programme quand on clique sur la croix */
gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	if(working) return(TRUE);
	disconnect(widget,data); /*les donnes envoyes ne servent a rien*/
	return(FALSE);
}

/* sortie du programme dans un des diffrents menus */
static void quit(GtkWidget *widget, gpointer data) {
  if(working) return;
  disconnect(widget,data); /*les donnes envoyes ne servent a rien*/
  gtk_main_quit();
}

static GtkItemFactoryEntry *
translate_entries (const GtkItemFactoryEntry *entries, gint n)
{
  gint i;
  GtkItemFactoryEntry *ret;

  ret=g_malloc( sizeof(GtkItemFactoryEntry) * n );
  for (i=0; i<n; i++) {
    /* Translation. Note the explicit use of gettext(). */
    ret[i].path=g_strdup( gettext(entries[i].path) );
    /* accelerator and item_type are not duped, only referenced */
    ret[i].accelerator=entries[i].accelerator;
    ret[i].callback=entries[i].callback;
    ret[i].callback_action=entries[i].callback_action;
    ret[i].item_type=entries[i].item_type;
  }
  return ret;
}

static void 
free_translated_entries(GtkItemFactoryEntry *entries, gint n)
{
  gint i;

  for (i=0; i<n; i++)
    g_free(entries[i].path);
  g_free(entries);
}

static GtkItemFactoryEntry menu_items[] = {
  {N_("/_File"),                            NULL,         NULL,           0, "<Branch>"},
  {N_("/File/tearoff"),                     NULL,         NULL,           0, "<Tearoff>" },
  {N_("/File/_Connect..."),                 "<control>C", dialog_connect, 0, NULL},
  {N_("/File/_Disconnect"),                 "<control>I", disconnect,     0, NULL},
  {N_("/File/_Abort"),                      NULL,         stop_job,       0, NULL},
  {N_("/File/_Options..."),                 NULL,         NULL,           0, NULL},
  {N_("/File/C_lear messages"),             NULL,         clear_messages, 0, NULL},
  {N_("/File/sep1"),                        NULL,         NULL,           0, "<Separator>"},
  {N_("/File/_Quit"),                       "<control>Q", quit,           0, NULL},

  {N_("/_Bookmarks"),                       NULL,         NULL,           0, "<Branch>"},
  {N_("/Bookmarks/tearoff"),                NULL,         NULL,           0, "<Tearoff>" },
  {N_("/Bookmarks/_Edit..."),               "<control>B", edit_bookmarks, 0, NULL},
  {N_("/Bookmarks/sep1"),                   NULL,         NULL,           0, "<Separator>"},

  {N_("/_Local"),                           NULL,         NULL,           0, "<Branch>"},
  {N_("/Local/tearoff"),                    NULL,         NULL,           0, "<Tearoff>" },
  {N_("/Local/_Reload dir"),                NULL,         reloadl,        0, NULL},
  {N_("/Local/C_d .."),                     NULL,         cdupl,          0, NULL},
  {N_("/Local/_Change dir..."),             NULL,         chdirl_gui,     0, NULL},
  {N_("/Local/_Make dir..."),               NULL,         make_dirl,      0, NULL},
  {N_("/Local/D_elete dir"),                NULL,         del_dirl,       0, NULL},
  {N_("/Local/De_lete files"),              NULL,         dell,           0, NULL},
  {N_("/Local/Delete _files recursively"), NULL,         dell_rec,       0, NULL},

  {N_("/_Remote"),                          NULL,         NULL,           0, "<Branch>"},
  {N_("/Remote/tearoff"),                   NULL,         NULL,           0, "<Tearoff>" },
  {N_("/Remote/_Reload dir"),               NULL,         reloadr,        0, NULL},
  {N_("/Remote/C_d .."),                    NULL,         cdupr,          0, NULL},
  {N_("/Remote/_Change dir..."),            NULL,         chdirr_gui,     0, NULL},
  {N_("/Remote/_Make dir..."),              NULL,         make_dirr,      0, NULL},
  {N_("/Remote/D_elete dir"),               NULL,         del_dirr,       0, NULL},
  {N_("/Remote/De_lete files"),             NULL,         delr,           0, NULL},
  {N_("/Remote/Delete _files recursively"), NULL,         delr_rec,       0, NULL},
  
  {N_("/_Help"),                            NULL,         NULL,           0, "<LastBranch>"},
  {N_("/Help/tearoff"),                     NULL,         NULL,           0, "<Tearoff>" },
  {N_("/Help/_About..."),                   NULL,         about,          0, NULL},
};

static void get_main_menu(GtkWidget *window, GtkWidget ** menubar) {
  gint nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);
  GtkItemFactoryEntry *translated_entries;
  GtkAccelGroup *accel_group;

  accel_group = gtk_accel_group_new();
  factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", accel_group);
  translated_entries = translate_entries(menu_items, nmenu_items);
  gtk_item_factory_create_items(factory, nmenu_items, translated_entries, NULL);
  free_translated_entries(translated_entries,nmenu_items);
  gtk_accel_group_attach (accel_group, GTK_OBJECT (window));
  if (menubar)
    *menubar = gtk_item_factory_get_widget(factory, "<main>");
}

static void 
clist_click_column (GtkCList *clist, gint column, gpointer data)
{
  if (column == 1)return;
  if (column == clist->sort_column)
    {
      if (clist->sort_type == GTK_SORT_ASCENDING)
	clist->sort_type = GTK_SORT_DESCENDING;
      else
	clist->sort_type = GTK_SORT_ASCENDING;
    }
  else
    gtk_clist_set_sort_column (clist, column);

  gtk_clist_sort (clist);
}

static void
clist_l_click ( GtkWidget *clist, gint row, gint column,
                GdkEventButton *event, gpointer data)
{
	gchar *text,*text2;
	GString *buffer;
	gint timer;
	gulong size;
	
	if(column!=0)return;
	if(0==gtk_clist_get_text(GTK_CLIST(clist),row,column,&text))
		return;
	if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_l),row),"d")!=0)
	{
		if(!connected)return;
		if(working) return;
			else working=1;
		buffer=g_string_new("");
		g_string_sprintf(buffer,_("Do you want to upload \"%s\" ?"),text);
		ask(_("Upload file ?"),buffer->str);
		if(bool)
		{
			transfert=1;
			gtk_clist_get_text(GTK_CLIST(clist),row,1,&text2);
			size=atol(text2);
			upload(text,size);
			working=0;
			gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
			timer=gtk_timeout_add(50,progress_timeout,progressbar);
			dirr();
			clear_progressbar(timer);
			transfert=0;
		}
		g_string_free(buffer,TRUE);
		return;
	}
	if(!transfert)
	{
		if(-1==chdir(text))
		{
			errorbox(_("Couldn't open the directory"));
			return;
		}
		dirl();
		gtk_entry_set_text(GTK_ENTRY(txte_l),(gchar *)get_dir_name());
	}
	
}

static void
clist_r_click ( GtkWidget *clist, gint row, gint column,
                GdkEventButton *event, gpointer data)
{
	gchar *text,*buffer2;
	GString *buffer;
	gint timer;
	gulong size;

	if(column!=0)return;
	if(working) return;
	if(0==gtk_clist_get_text(GTK_CLIST(clist),row,1,&text))
		return;
	size=atol(text);
	if(0==gtk_clist_get_text(GTK_CLIST(clist),row,column,&text))
		return;
	if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"f")==0)
	{	
		working=1;
		buffer=g_string_new("");
		g_string_sprintf(buffer,_("Do you want to download \"%s\" ?"),text);
		ask(_("Download file ?"),buffer->str);
		if(bool)
		{
			transfert=1;
			download(text,size);
			transfert=0;
		}
		g_string_free(buffer,TRUE);
		working=0;
		return;
	}
	if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"lf")==0)
	{
		link2file(&buffer2,&text);
		working=1;
		gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
		timer=gtk_timeout_add(50,progress_timeout,progressbar);
		if(0!=chdir_r(buffer2))
		{
			pwd();
			dirr();
			clear_progressbar(timer);
		}
		else
		{
			clear_progressbar(timer);
			buffer=g_string_new("");
			g_string_sprintf(buffer,_("Do you want to download \"%s\" ?"),buffer2);
			ask(_("Download file ?"),buffer->str);
			if(bool)
			{
				transfert=1;
				download(buffer2,size);
				transfert=0;
			}
			g_string_free(buffer,TRUE);
			g_free(buffer2);
		}
		working=0;
		return;
	}
	if(strcmp((gchar *)gtk_clist_get_row_data(GTK_CLIST(clist_r),row),"ld")==0)
	{
		link2file(&buffer2,&text);
		working=1;
		gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
		timer=gtk_timeout_add(50,progress_timeout,progressbar);
		if(0!=chdir_r(buffer2))
		{
			pwd();
			dirr();
		}
		g_free(buffer2);
		clear_progressbar(timer);
		working=0;
		return;
	}
	working=1;
	gtk_progress_set_activity_mode(GTK_PROGRESS(progressbar),1);
	timer=gtk_timeout_add(50,progress_timeout,progressbar);
	if(0!=chdir_r(text))
	{
		pwd();
		dirr();
		working=0;
	}
	clear_progressbar(timer);
}

static gchar * translate_titles(gchar *titles)
{
	gchar *temp;
	
	temp=g_malloc(strlen(titles));
	sprintf(temp,gettext(titles));
	return temp;
}

static void free_tt(gchar *titles[])
{
	g_free(titles[1]);
	g_free(titles[0]);
}

gint main(gint argc, gchar *argv[])
{
	GtkWidget *window;
	GtkWidget *pane1;
	GtkWidget *pane2;
	GtkWidget *vbox;
	GtkWidget *vbox2;
	GtkWidget *hbox;
	GtkWidget *hbox2;
	GtkWidget *menubar;
	GtkWidget *handle_box;
	GtkWidget *scrolled_win;
	GtkWidget *bbox;
	GtkWidget *button;
	GtkWidget *toolbar;
	gchar *titles[2] = { N_("File"), N_("Size") };
	gchar *ttitles[2];
	GtkStyle *style;
	
	/* truc pour le dnd (piqu de gftp) */
	/* voir a quoi ca sert */
/*	const GtkTargetEntry possible_types[] = {
      {"STRING",			0,	0},
      {"text/plain", 			0, 	0},
      {"application/x-rootwin-drop", 	0, 	1}};  */
	/* fin */
	

	#ifdef ENABLE_NLS
	bindtextdomain(PACKAGE,LOCALEDIR);
	textdomain(PACKAGE); /*utile pour choisir le langage*/
	#endif
	
	/*initialisation de gtk*/
	gtk_init (&argc, &argv);

	connected=0;
	transfert=0;

	/*cration de la fenetre principale*/
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (window), "delete_event", GTK_SIGNAL_FUNC (delete_event), NULL);
	gtk_signal_connect (GTK_OBJECT (window), "destroy", GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
	
	gtk_window_set_title (GTK_WINDOW (window), ""PACKAGE" "VERSION"");
	gtk_widget_set_usize (GTK_WIDGET(window), 500, 400);
	gtk_container_set_border_width (GTK_CONTAINER (window), 0);
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (window), vbox);
		
	/*cration du menu*/
	handle_box = gtk_handle_box_new ();
	gtk_box_pack_start (GTK_BOX (vbox), handle_box, FALSE, FALSE, 0);
	get_main_menu(window,&menubar);
	gtk_container_add (GTK_CONTAINER (handle_box), menubar);


	init_bookmarks();
	
	/*cration de la barre de boutons*/
	handle_box = gtk_handle_box_new ();
	gtk_box_pack_start (GTK_BOX (vbox), handle_box, FALSE, FALSE, 0);
	toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
	gtk_toolbar_set_button_relief (GTK_TOOLBAR (toolbar), GTK_RELIEF_NORMAL);

	gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			  _("Quit"), _("Quit the program"), NULL, NULL,
			   GTK_SIGNAL_FUNC(quit), toolbar);
	gtk_toolbar_append_space (GTK_TOOLBAR(toolbar));
	gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			  _("Connect"), _("Connect to a remote site"), NULL, NULL,
			   GTK_SIGNAL_FUNC(dialog_connect), toolbar);
	disconnect_btn=gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			  _("Disconnect"), _("Disconnect"), NULL, NULL,
			   GTK_SIGNAL_FUNC(disconnect), toolbar);
	gtk_toolbar_append_space (GTK_TOOLBAR(toolbar));
	abort_btn=gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			  _("Abort"), _("Abort current transfer"), NULL, NULL,
			   GTK_SIGNAL_FUNC(stop_job), toolbar);
	gtk_widget_set_sensitive (abort_btn, 0);

	gtk_container_add (GTK_CONTAINER (handle_box), toolbar);

	/*cration de 2 sous fenetres*/
	pane1 = gtk_vpaned_new ();
	gtk_paned_set_position(GTK_PANED(pane1),230);	
	gtk_paned_set_handle_size (GTK_PANED(pane1), 10);
	gtk_paned_set_gutter_size (GTK_PANED(pane1), 14);
	
	gtk_box_pack_start (GTK_BOX (vbox), pane1, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER(pane1), 2);
	
	/*la fenetre de texte*/
	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 2);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
				      GTK_POLICY_AUTOMATIC, 
				      GTK_POLICY_AUTOMATIC);
	gtk_paned_pack2 (GTK_PANED (pane1), scrolled_win,1,1);
	text = gtk_text_new (NULL, NULL);
	gtk_text_set_editable (GTK_TEXT (text), FALSE);
	gtk_container_add (GTK_CONTAINER (scrolled_win), text);
	gtk_paned_pack2 (GTK_PANED (pane1), text,1,1);
	
	/*on divise la deuxieme sous fenetre en 2*/
	pane2 = gtk_hpaned_new ();
	gtk_paned_set_position(GTK_PANED(pane2),260);
	gtk_paned_set_handle_size (GTK_PANED(pane2), 10);
	gtk_paned_set_gutter_size (GTK_PANED(pane2), 14);

	gtk_paned_pack1 (GTK_PANED (pane1), pane2,1,1);
	gtk_container_set_border_width (GTK_CONTAINER(pane2), 2);
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_paned_pack1 (GTK_PANED (pane2), hbox,1,1);
	
	/*cration de la fenetre de l'ordinateur local*/
	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 0);
	
	hbox2 = gtk_hbox_new (FALSE,0);
	gtk_box_pack_start (GTK_BOX (vbox2), hbox2, FALSE, FALSE, 0);

	toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
	gtk_toolbar_set_button_relief (GTK_TOOLBAR (toolbar), GTK_RELIEF_NORMAL);
	gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			  _("../"), _("Cd .."), NULL, NULL,
			   GTK_SIGNAL_FUNC(cdupl), toolbar);
	gtk_toolbar_append_space (GTK_TOOLBAR(toolbar));
	gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			  _("Reload"), _("Reload directory"), NULL, NULL,
			   GTK_SIGNAL_FUNC(reloadl), toolbar);
	gtk_box_pack_start (GTK_BOX (hbox2), toolbar, FALSE, FALSE, 0);
	
	txte_l = gtk_entry_new();
	gtk_box_pack_start (GTK_BOX (hbox2), txte_l, TRUE, TRUE, 0);
	gtk_entry_set_text(GTK_ENTRY(txte_l),getenv("HOME"));
	gtk_container_set_border_width (GTK_CONTAINER (vbox2), 2);
	gtk_signal_connect(GTK_OBJECT(txte_l), "activate", GTK_SIGNAL_FUNC(chdirl),txte_l);
	
	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
				      GTK_POLICY_AUTOMATIC, 
				      GTK_POLICY_AUTOMATIC);
	
	gtk_box_pack_start (GTK_BOX (vbox2), scrolled_win, TRUE, TRUE, 0);
	ttitles[0]=translate_titles(titles[0]);
	ttitles[1]=translate_titles(titles[1]);
	clist_l = gtk_clist_new_with_titles(2,ttitles);
	
	gtk_clist_set_selection_mode(GTK_CLIST(clist_l), GTK_SELECTION_EXTENDED);
	gtk_clist_set_column_auto_resize(GTK_CLIST(clist_l),0,TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(clist_l),1,TRUE);
	
	gtk_signal_connect(GTK_OBJECT(clist_l),
                        "select_row",
                        GTK_SIGNAL_FUNC(clist_l_click),
                        NULL);
	gtk_container_add (GTK_CONTAINER (scrolled_win), clist_l);
	gtk_signal_connect (GTK_OBJECT (clist_l), "click_column",
			(GtkSignalFunc) clist_click_column, NULL);

	chdir(getenv("HOME"));
	dirl();
	
	
	
	/* dnd -> a finir (a commencer...) */
/*	gtk_drag_source_set (clist_l, GDK_BUTTON1_MASK, possible_types, 3,
		GDK_ACTION_COPY | GDK_ACTION_MOVE);
	gtk_drag_dest_set (clist_l, GTK_DEST_DEFAULT_ALL, possible_types, 2,
		GDK_ACTION_COPY | GDK_ACTION_MOVE);*/
	/* fin dnd */
	
	
	
	/*les boutons pour lancer un tlchargement*/
	bbox = gtk_vbutton_box_new ();
	gtk_button_box_set_child_size (GTK_BUTTON_BOX (bbox), 0, 0);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), 
		     GTK_BUTTONBOX_SPREAD );
	gtk_container_set_border_width (GTK_CONTAINER (bbox), 5);
	gtk_box_pack_start (GTK_BOX (hbox), bbox, FALSE, TRUE, 0);
	button = gtk_button_new_with_label (_(">>"));
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC (go_upload), NULL);
	gtk_container_add (GTK_CONTAINER (bbox), button);
	button = gtk_button_new_with_label (_("<<"));
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC (go_download), NULL);
	gtk_container_add (GTK_CONTAINER (bbox), button);


	/*la fenetre de l'ordinateur distant*/
	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_paned_pack2 (GTK_PANED (pane2), vbox2,1,1);

	hbox2 = gtk_hbox_new (FALSE,0);
	gtk_box_pack_start (GTK_BOX (vbox2), hbox2, FALSE, FALSE, 0);
	toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
	gtk_toolbar_set_button_relief (GTK_TOOLBAR (toolbar), GTK_RELIEF_NORMAL);
	cd_up_remote_btn=gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			  _("../"), _("Cd .."), NULL, NULL,
			   GTK_SIGNAL_FUNC(cdupr), toolbar);
	gtk_toolbar_append_space (GTK_TOOLBAR(toolbar));
	reload_remote_btn=gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			  _("Reload"), _("Reload directory"), NULL, NULL,
			   GTK_SIGNAL_FUNC(reloadr), toolbar);
	gtk_box_pack_start (GTK_BOX (hbox2), toolbar, FALSE, FALSE, 0);
	
	txte_r = gtk_entry_new();
	gtk_box_pack_start (GTK_BOX (hbox2), txte_r, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (vbox2), 2);
	gtk_entry_set_editable(GTK_ENTRY(txte_r),FALSE);
	gtk_signal_connect(GTK_OBJECT(txte_r), "activate",
			GTK_SIGNAL_FUNC(chdirr),txte_r);
	
	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
				      GTK_POLICY_AUTOMATIC, 
				      GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (GTK_BOX (vbox2), scrolled_win, TRUE, TRUE, 0);
	clist_r = gtk_clist_new_with_titles(2,ttitles);
	free_tt(ttitles);
	gtk_clist_set_column_auto_resize(GTK_CLIST(clist_r),0,TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(clist_r),1,TRUE);
	gtk_clist_set_selection_mode(GTK_CLIST(clist_r), GTK_SELECTION_EXTENDED);
	gtk_signal_connect(GTK_OBJECT( clist_r),
                        "select_row",
                        GTK_SIGNAL_FUNC(clist_r_click),
                        NULL);

	gtk_container_add (GTK_CONTAINER (scrolled_win), clist_r);
	gtk_signal_connect (GTK_OBJECT (clist_r), "click_column",
			(GtkSignalFunc) clist_click_column, NULL);
	
	/*cration de la barre d'tat*/
	handle_box = gtk_handle_box_new ();
	gtk_box_pack_start (GTK_BOX (vbox), handle_box, FALSE, FALSE, 0);
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (handle_box), hbox);
	
	/*zone de texte*/
	statusbar = gtk_statusbar_new ();
	gtk_box_pack_start (GTK_BOX (hbox), statusbar, TRUE, TRUE, 0);
	gtk_statusbar_push(GTK_STATUSBAR(statusbar),1,_(" Not Connected "));
	/*indicateur de la progression*/
	progressbar = gtk_progress_bar_new();
	gtk_box_pack_start (GTK_BOX (hbox), progressbar, FALSE, FALSE, 0);
	
	hide_remote_menu();
	/*affichage*/
	gtk_widget_show_all (vbox);
	gtk_widget_show(window);
	
	/*dbut de la boucle principale*/
	working=0;
	
	style = gtk_widget_get_style(window);
	dir = gdk_pixmap_create_from_xpm_d(window->window,  &dirmask,
		&style->bg[GTK_STATE_NORMAL],(gchar **)dir_xpm);
	diropen = gdk_pixmap_create_from_xpm_d(window->window,  &diropenmask,
		&style->bg[GTK_STATE_NORMAL],(gchar **)diropen_xpm);

	
	gtk_main();

        return 0;
}
